package net.minecraft.util.math.random;

public interface BaseRandom extends Random {
	float FLOAT_MULTIPLIER = 5.9604645E-8F;
	double DOUBLE_MULTIPLIER = 1.110223E-16F;

	int next(int bits);

	@Override
	default int nextInt() {
		return this.next(32);
	}

	@Override
	default int nextInt(int bound) {
		if (bound <= 0) {
			throw new IllegalArgumentException("Bound must be positive");
		} else if ((bound & bound - 1) == 0) {
			return (int)((long)bound * this.next(31) >> 31);
		} else {
			int i;
			int j;
			do {
				i = this.next(31);
				j = i % bound;
			} while (i - j + (bound - 1) < 0);

			return j;
		}
	}

	@Override
	default long nextLong() {
		int i = this.next(32);
		int j = this.next(32);
		long l = (long)i << 32;
		return l + j;
	}

	@Override
	default boolean nextBoolean() {
		return this.next(1) != 0;
	}

	@Override
	default float nextFloat() {
		return this.next(24) * 5.9604645E-8F;
	}

	@Override
	default double nextDouble() {
		int i = this.next(26);
		int j = this.next(27);
		long l = ((long)i << 27) + j;
		return l * 1.110223E-16F;
	}
}
