package net.minecraft.registry.tag;

import net.minecraft.block.Block;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.util.Identifier;

public final class BlockTags {
	public static final TagKey<Block> WOOL = of("wool");
	public static final TagKey<Block> PLANKS = of("planks");
	public static final TagKey<Block> STONE_BRICKS = of("stone_bricks");
	public static final TagKey<Block> WOODEN_BUTTONS = of("wooden_buttons");
	public static final TagKey<Block> STONE_BUTTONS = of("stone_buttons");
	public static final TagKey<Block> BUTTONS = of("buttons");
	public static final TagKey<Block> WOOL_CARPETS = of("wool_carpets");
	public static final TagKey<Block> WOODEN_DOORS = of("wooden_doors");
	public static final TagKey<Block> WOODEN_STAIRS = of("wooden_stairs");
	public static final TagKey<Block> WOODEN_SLABS = of("wooden_slabs");
	public static final TagKey<Block> WOODEN_FENCES = of("wooden_fences");
	public static final TagKey<Block> PRESSURE_PLATES = of("pressure_plates");
	public static final TagKey<Block> WOODEN_PRESSURE_PLATES = of("wooden_pressure_plates");
	public static final TagKey<Block> STONE_PRESSURE_PLATES = of("stone_pressure_plates");
	public static final TagKey<Block> WOODEN_TRAPDOORS = of("wooden_trapdoors");
	public static final TagKey<Block> DOORS = of("doors");
	public static final TagKey<Block> SAPLINGS = of("saplings");
	public static final TagKey<Block> LOGS_THAT_BURN = of("logs_that_burn");
	public static final TagKey<Block> OVERWORLD_NATURAL_LOGS = of("overworld_natural_logs");
	public static final TagKey<Block> LOGS = of("logs");
	public static final TagKey<Block> DARK_OAK_LOGS = of("dark_oak_logs");
	public static final TagKey<Block> OAK_LOGS = of("oak_logs");
	public static final TagKey<Block> BIRCH_LOGS = of("birch_logs");
	public static final TagKey<Block> ACACIA_LOGS = of("acacia_logs");
	public static final TagKey<Block> CHERRY_LOGS = of("cherry_logs");
	public static final TagKey<Block> JUNGLE_LOGS = of("jungle_logs");
	public static final TagKey<Block> SPRUCE_LOGS = of("spruce_logs");
	public static final TagKey<Block> MANGROVE_LOGS = of("mangrove_logs");
	public static final TagKey<Block> CRIMSON_STEMS = of("crimson_stems");
	public static final TagKey<Block> WARPED_STEMS = of("warped_stems");
	public static final TagKey<Block> BAMBOO_BLOCKS = of("bamboo_blocks");
	public static final TagKey<Block> WART_BLOCKS = of("wart_blocks");
	public static final TagKey<Block> BANNERS = of("banners");
	public static final TagKey<Block> SAND = of("sand");
	public static final TagKey<Block> SMELTS_TO_GLASS = of("smelts_to_glass");
	public static final TagKey<Block> STAIRS = of("stairs");
	public static final TagKey<Block> SLABS = of("slabs");
	public static final TagKey<Block> WALLS = of("walls");
	public static final TagKey<Block> ANVIL = of("anvil");
	public static final TagKey<Block> RAILS = of("rails");
	public static final TagKey<Block> LEAVES = of("leaves");
	public static final TagKey<Block> TRAPDOORS = of("trapdoors");
	public static final TagKey<Block> SMALL_FLOWERS = of("small_flowers");
	public static final TagKey<Block> BEDS = of("beds");
	public static final TagKey<Block> FENCES = of("fences");
	public static final TagKey<Block> TALL_FLOWERS = of("tall_flowers");
	public static final TagKey<Block> FLOWERS = of("flowers");
	public static final TagKey<Block> PIGLIN_REPELLENTS = of("piglin_repellents");
	public static final TagKey<Block> GOLD_ORES = of("gold_ores");
	public static final TagKey<Block> IRON_ORES = of("iron_ores");
	public static final TagKey<Block> DIAMOND_ORES = of("diamond_ores");
	public static final TagKey<Block> REDSTONE_ORES = of("redstone_ores");
	public static final TagKey<Block> LAPIS_ORES = of("lapis_ores");
	public static final TagKey<Block> COAL_ORES = of("coal_ores");
	public static final TagKey<Block> EMERALD_ORES = of("emerald_ores");
	public static final TagKey<Block> COPPER_ORES = of("copper_ores");
	public static final TagKey<Block> CANDLES = of("candles");
	public static final TagKey<Block> DIRT = of("dirt");
	public static final TagKey<Block> TERRACOTTA = of("terracotta");
	public static final TagKey<Block> COMPLETES_FIND_TREE_TUTORIAL = of("completes_find_tree_tutorial");
	public static final TagKey<Block> FLOWER_POTS = of("flower_pots");
	public static final TagKey<Block> ENDERMAN_HOLDABLE = of("enderman_holdable");
	public static final TagKey<Block> ICE = of("ice");
	public static final TagKey<Block> VALID_SPAWN = of("valid_spawn");
	public static final TagKey<Block> IMPERMEABLE = of("impermeable");
	public static final TagKey<Block> UNDERWATER_BONEMEALS = of("underwater_bonemeals");
	public static final TagKey<Block> CORAL_BLOCKS = of("coral_blocks");
	public static final TagKey<Block> WALL_CORALS = of("wall_corals");
	public static final TagKey<Block> CORAL_PLANTS = of("coral_plants");
	public static final TagKey<Block> CORALS = of("corals");
	public static final TagKey<Block> BAMBOO_PLANTABLE_ON = of("bamboo_plantable_on");
	public static final TagKey<Block> STANDING_SIGNS = of("standing_signs");
	public static final TagKey<Block> WALL_SIGNS = of("wall_signs");
	public static final TagKey<Block> SIGNS = of("signs");
	public static final TagKey<Block> CEILING_HANGING_SIGNS = of("ceiling_hanging_signs");
	public static final TagKey<Block> WALL_HANGING_SIGNS = of("wall_hanging_signs");
	public static final TagKey<Block> ALL_HANGING_SIGNS = of("all_hanging_signs");
	public static final TagKey<Block> ALL_SIGNS = of("all_signs");
	public static final TagKey<Block> DRAGON_IMMUNE = of("dragon_immune");
	public static final TagKey<Block> DRAGON_TRANSPARENT = of("dragon_transparent");
	public static final TagKey<Block> WITHER_IMMUNE = of("wither_immune");
	public static final TagKey<Block> WITHER_SUMMON_BASE_BLOCKS = of("wither_summon_base_blocks");
	public static final TagKey<Block> BEEHIVES = of("beehives");
	public static final TagKey<Block> CROPS = of("crops");
	public static final TagKey<Block> BEE_GROWABLES = of("bee_growables");
	public static final TagKey<Block> PORTALS = of("portals");
	public static final TagKey<Block> FIRE = of("fire");
	public static final TagKey<Block> NYLIUM = of("nylium");
	public static final TagKey<Block> BEACON_BASE_BLOCKS = of("beacon_base_blocks");
	public static final TagKey<Block> SOUL_SPEED_BLOCKS = of("soul_speed_blocks");
	public static final TagKey<Block> WALL_POST_OVERRIDE = of("wall_post_override");
	public static final TagKey<Block> CLIMBABLE = of("climbable");
	public static final TagKey<Block> FALL_DAMAGE_RESETTING = of("fall_damage_resetting");
	public static final TagKey<Block> SHULKER_BOXES = of("shulker_boxes");
	public static final TagKey<Block> HOGLIN_REPELLENTS = of("hoglin_repellents");
	public static final TagKey<Block> SOUL_FIRE_BASE_BLOCKS = of("soul_fire_base_blocks");
	public static final TagKey<Block> STRIDER_WARM_BLOCKS = of("strider_warm_blocks");
	public static final TagKey<Block> CAMPFIRES = of("campfires");
	public static final TagKey<Block> GUARDED_BY_PIGLINS = of("guarded_by_piglins");
	public static final TagKey<Block> PREVENT_MOB_SPAWNING_INSIDE = of("prevent_mob_spawning_inside");
	public static final TagKey<Block> FENCE_GATES = of("fence_gates");
	public static final TagKey<Block> UNSTABLE_BOTTOM_CENTER = of("unstable_bottom_center");
	public static final TagKey<Block> MUSHROOM_GROW_BLOCK = of("mushroom_grow_block");
	public static final TagKey<Block> INFINIBURN_OVERWORLD = of("infiniburn_overworld");
	public static final TagKey<Block> INFINIBURN_NETHER = of("infiniburn_nether");
	public static final TagKey<Block> INFINIBURN_END = of("infiniburn_end");
	public static final TagKey<Block> BASE_STONE_OVERWORLD = of("base_stone_overworld");
	public static final TagKey<Block> STONE_ORE_REPLACEABLES = of("stone_ore_replaceables");
	public static final TagKey<Block> DEEPSLATE_ORE_REPLACEABLES = of("deepslate_ore_replaceables");
	public static final TagKey<Block> BASE_STONE_NETHER = of("base_stone_nether");
	public static final TagKey<Block> OVERWORLD_CARVER_REPLACEABLES = of("overworld_carver_replaceables");
	public static final TagKey<Block> NETHER_CARVER_REPLACEABLES = of("nether_carver_replaceables");
	public static final TagKey<Block> CANDLE_CAKES = of("candle_cakes");
	public static final TagKey<Block> CAULDRONS = of("cauldrons");
	public static final TagKey<Block> CRYSTAL_SOUND_BLOCKS = of("crystal_sound_blocks");
	public static final TagKey<Block> INSIDE_STEP_SOUND_BLOCKS = of("inside_step_sound_blocks");
	public static final TagKey<Block> COMBINATION_STEP_SOUND_BLOCKS = of("combination_step_sound_blocks");
	public static final TagKey<Block> OCCLUDES_VIBRATION_SIGNALS = of("occludes_vibration_signals");
	public static final TagKey<Block> DAMPENS_VIBRATIONS = of("dampens_vibrations");
	public static final TagKey<Block> DRIPSTONE_REPLACEABLE_BLOCKS = of("dripstone_replaceable_blocks");
	public static final TagKey<Block> CAVE_VINES = of("cave_vines");
	public static final TagKey<Block> MOSS_REPLACEABLE = of("moss_replaceable");
	public static final TagKey<Block> LUSH_GROUND_REPLACEABLE = of("lush_ground_replaceable");
	public static final TagKey<Block> AZALEA_ROOT_REPLACEABLE = of("azalea_root_replaceable");
	public static final TagKey<Block> SMALL_DRIPLEAF_PLACEABLE = of("small_dripleaf_placeable");
	public static final TagKey<Block> BIG_DRIPLEAF_PLACEABLE = of("big_dripleaf_placeable");
	public static final TagKey<Block> SNOW = of("snow");
	public static final TagKey<Block> AXE_MINEABLE = of("mineable/axe");
	public static final TagKey<Block> HOE_MINEABLE = of("mineable/hoe");
	public static final TagKey<Block> PICKAXE_MINEABLE = of("mineable/pickaxe");
	public static final TagKey<Block> SHOVEL_MINEABLE = of("mineable/shovel");
	public static final TagKey<Block> SWORD_EFFICIENT = of("sword_efficient");
	public static final TagKey<Block> NEEDS_DIAMOND_TOOL = of("needs_diamond_tool");
	public static final TagKey<Block> NEEDS_IRON_TOOL = of("needs_iron_tool");
	public static final TagKey<Block> NEEDS_STONE_TOOL = of("needs_stone_tool");
	public static final TagKey<Block> FEATURES_CANNOT_REPLACE = of("features_cannot_replace");
	public static final TagKey<Block> LAVA_POOL_STONE_CANNOT_REPLACE = of("lava_pool_stone_cannot_replace");
	public static final TagKey<Block> GEODE_INVALID_BLOCKS = of("geode_invalid_blocks");
	public static final TagKey<Block> FROG_PREFER_JUMP_TO = of("frog_prefer_jump_to");
	public static final TagKey<Block> SCULK_REPLACEABLE = of("sculk_replaceable");
	public static final TagKey<Block> SCULK_REPLACEABLE_WORLD_GEN = of("sculk_replaceable_world_gen");
	public static final TagKey<Block> ANCIENT_CITY_REPLACEABLE = of("ancient_city_replaceable");
	public static final TagKey<Block> VIBRATION_RESONATORS = of("vibration_resonators");
	public static final TagKey<Block> ANIMALS_SPAWNABLE_ON = of("animals_spawnable_on");
	public static final TagKey<Block> AXOLOTLS_SPAWNABLE_ON = of("axolotls_spawnable_on");
	public static final TagKey<Block> GOATS_SPAWNABLE_ON = of("goats_spawnable_on");
	public static final TagKey<Block> MOOSHROOMS_SPAWNABLE_ON = of("mooshrooms_spawnable_on");
	public static final TagKey<Block> PARROTS_SPAWNABLE_ON = of("parrots_spawnable_on");
	public static final TagKey<Block> POLAR_BEARS_SPAWNABLE_ON_ALTERNATE = of("polar_bears_spawnable_on_alternate");
	public static final TagKey<Block> RABBITS_SPAWNABLE_ON = of("rabbits_spawnable_on");
	public static final TagKey<Block> FOXES_SPAWNABLE_ON = of("foxes_spawnable_on");
	public static final TagKey<Block> WOLVES_SPAWNABLE_ON = of("wolves_spawnable_on");
	public static final TagKey<Block> FROGS_SPAWNABLE_ON = of("frogs_spawnable_on");
	public static final TagKey<Block> AZALEA_GROWS_ON = of("azalea_grows_on");
	public static final TagKey<Block> CONVERTABLE_TO_MUD = of("convertable_to_mud");
	public static final TagKey<Block> MANGROVE_LOGS_CAN_GROW_THROUGH = of("mangrove_logs_can_grow_through");
	public static final TagKey<Block> MANGROVE_ROOTS_CAN_GROW_THROUGH = of("mangrove_roots_can_grow_through");
	public static final TagKey<Block> DEAD_BUSH_MAY_PLACE_ON = of("dead_bush_may_place_on");
	public static final TagKey<Block> SNAPS_GOAT_HORN = of("snaps_goat_horn");
	public static final TagKey<Block> REPLACEABLE_BY_TREES = of("replaceable_by_trees");
	public static final TagKey<Block> SNOW_LAYER_CANNOT_SURVIVE_ON = of("snow_layer_cannot_survive_on");
	public static final TagKey<Block> SNOW_LAYER_CAN_SURVIVE_ON = of("snow_layer_can_survive_on");
	public static final TagKey<Block> INVALID_SPAWN_INSIDE = of("invalid_spawn_inside");
	public static final TagKey<Block> SNIFFER_DIGGABLE_BLOCK = of("sniffer_diggable_block");
	public static final TagKey<Block> SNIFFER_EGG_HATCH_BOOST = of("sniffer_egg_hatch_boost");
	public static final TagKey<Block> TRAIL_RUINS_REPLACEABLE = of("trail_ruins_replaceable");
	public static final TagKey<Block> REPLACEABLE = of("replaceable");
	public static final TagKey<Block> ENCHANTMENT_POWER_PROVIDER = of("enchantment_power_provider");
	public static final TagKey<Block> ENCHANTMENT_POWER_TRANSMITTER = of("enchantment_power_transmitter");
	public static final TagKey<Block> MAINTAINS_FARMLAND = of("maintains_farmland");

	private BlockTags() {
	}

	private static TagKey<Block> of(String id) {
		return TagKey.of(RegistryKeys.BLOCK, new Identifier(id));
	}
}
