package net.minecraft.client.render.entity.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

/**
 * Contains common model part names used in {@linkplain EntityModel entity models}.
 */
@Environment(EnvType.CLIENT)
public class EntityModelPartNames {
	/**
	 * The key of a left fin model part, whose value is {@value}.
	 */
	public static final String LEFT_FIN = "left_fin";
	/**
	 * The key of a right fin model part, whose value is {@value}.
	 */
	public static final String RIGHT_FIN = "right_fin";
	/**
	 * The key of a top fin model part, whose value is {@value}.
	 */
	public static final String TOP_FIN = "top_fin";
	/**
	 * The key of a bottom fin model part, whose value is {@value}.
	 */
	public static final String BOTTOM_FIN = "bottom_fin";
	/**
	 * The key of a tail fin model part, whose value is {@value}.
	 */
	public static final String TAIL_FIN = "tail_fin";
	/**
	 * The key of a left blue fin model part, whose value is {@value}.
	 */
	public static final String LEFT_BLUE_FIN = "left_blue_fin";
	/**
	 * The key of a right blue fin model part, whose value is {@value}.
	 */
	public static final String RIGHT_BLUE_FIN = "right_blue_fin";
	/**
	 * The key of a left arm model part, whose value is {@value}.
	 */
	public static final String LEFT_ARM = "left_arm";
	/**
	 * The key of a right arm model part, whose value is {@value}.
	 */
	public static final String RIGHT_ARM = "right_arm";
	/**
	 * The key of a left wing model part, whose value is {@value}.
	 */
	public static final String LEFT_WING = "left_wing";
	/**
	 * The key of a right wing model part, whose value is {@value}.
	 */
	public static final String RIGHT_WING = "right_wing";
	/**
	 * The key of a left wing base model part, whose value is {@value}.
	 */
	public static final String LEFT_WING_BASE = "left_wing_base";
	/**
	 * The key of a right wing base model part, whose value is {@value}.
	 */
	public static final String RIGHT_WING_BASE = "right_wing_base";
	/**
	 * The key of a left wing tip model part, whose value is {@value}.
	 */
	public static final String LEFT_WING_TIP = "left_wing_tip";
	/**
	 * The key of a right wing tip model part, whose value is {@value}.
	 */
	public static final String RIGHT_WING_TIP = "right_wing_tip";
	/**
	 * The key of a left ear model part, whose value is {@value}.
	 */
	public static final String LEFT_EAR = "left_ear";
	/**
	 * The key of a right ear model part, whose value is {@value}.
	 */
	public static final String RIGHT_EAR = "right_ear";
	/**
	 * The key of a left leg model part, whose value is {@value}.
	 */
	public static final String LEFT_LEG = "left_leg";
	/**
	 * The key of a right leg model part, whose value is {@value}.
	 */
	public static final String RIGHT_LEG = "right_leg";
	/**
	 * The key of a left hind leg model part, whose value is {@value}.
	 */
	public static final String LEFT_HIND_LEG = "left_hind_leg";
	/**
	 * The key of a right hind leg model part, whose value is {@value}.
	 */
	public static final String RIGHT_HIND_LEG = "right_hind_leg";
	/**
	 * The key of a left mid leg part, whose value is {@value}.
	 */
	public static final String LEFT_MID_LEG = "left_mid_leg";
	/**
	 * The key of a right mid leg part, whose value is {@value}.
	 */
	public static final String RIGHT_MID_LEG = "right_mid_leg";
	/**
	 * The key of a left front leg model part, whose value is {@value}.
	 */
	public static final String LEFT_FRONT_LEG = "left_front_leg";
	/**
	 * The key of a right front leg model part, whose value is {@value}.
	 */
	public static final String RIGHT_FRONT_LEG = "right_front_leg";
	/**
	 * The key of a left hind foot model part, whose value is {@value}.
	 */
	public static final String LEFT_HIND_FOOT = "left_hind_foot";
	/**
	 * The key of a right hind foot model part, whose value is {@value}.
	 */
	public static final String RIGHT_HIND_FOOT = "right_hind_foot";
	/**
	 * The key of a left front foot model part, whose value is {@value}.
	 */
	public static final String LEFT_FRONT_FOOT = "left_front_foot";
	/**
	 * The key of a right front foot model part, whose value is {@value}.
	 */
	public static final String RIGHT_FRONT_FOOT = "right_front_foot";
	/**
	 * The key of a left hind leg tip model part, whose value is {@value}.
	 */
	public static final String LEFT_HIND_LEG_TIP = "left_hind_leg_tip";
	/**
	 * The key of a right hind leg tip model part, whose value is {@value}.
	 */
	public static final String RIGHT_HIND_LEG_TIP = "right_hind_leg_tip";
	/**
	 * The key of a left front leg tip model part, whose value is {@value}.
	 */
	public static final String LEFT_FRONT_LEG_TIP = "left_front_leg_tip";
	/**
	 * The key of a right front leg tip model part, whose value is {@value}.
	 */
	public static final String RIGHT_FRONT_LEG_TIP = "right_front_leg_tip";
	/**
	 * The key of a left lid model part, whose value is {@value}.
	 */
	public static final String LEFT_LID = "left_lid";
	/**
	 * The key of a right lid model part, whose value is {@value}.
	 */
	public static final String RIGHT_LID = "right_lid";
	/**
	 * The key of a left chest model part, whose value is {@value}.
	 */
	public static final String LEFT_CHEST = "left_chest";
	/**
	 * The key of a right chest model part, whose value is {@value}.
	 */
	public static final String RIGHT_CHEST = "right_chest";
	/**
	 * The key of a left horn model part, whose value is {@value}.
	 */
	public static final String LEFT_HORN = "left_horn";
	/**
	 * The key of a right horn model part, whose value is {@value}.
	 */
	public static final String RIGHT_HORN = "right_horn";
	/**
	 * The key of a left eye model part, whose value is {@value}.
	 */
	public static final String LEFT_EYE = "left_eye";
	/**
	 * The key of a right eye model part, whose value is {@value}.
	 */
	public static final String RIGHT_EYE = "right_eye";
	/**
	 * The key of a jaw model part, whose value is {@value}.
	 */
	public static final String JAW = "jaw";
	/**
	 * The key of a nose model part, whose value is {@value}.
	 */
	public static final String NOSE = "nose";
	/**
	 * The key of an arms model part, whose value is {@value}.
	 */
	public static final String ARMS = "arms";
	/**
	 * The key of a tail model part, whose value is {@value}.
	 */
	public static final String TAIL = "tail";
	/**
	 * The key of a cube model part, whose value is {@value}.
	 */
	public static final String CUBE = "cube";
	/**
	 * The key of a beak model part, whose value is {@value}.
	 */
	public static final String BEAK = "beak";
	/**
	 * The key of a back fin model part, whose value is {@value}.
	 */
	public static final String BACK_FIN = "back_fin";
	/**
	 * The key of a mane model part, whose value is {@value}.
	 */
	public static final String MANE = "mane";
	/**
	 * The key of a neck model part, whose value is {@value}.
	 */
	public static final String NECK = "neck";
	/**
	 * The key of a mouth model part, whose value is {@value}.
	 */
	public static final String MOUTH = "mouth";
	/**
	 * The key of a head model part, whose value is {@value}.
	 */
	public static final String HEAD = "head";
	/**
	 * The key of a hat model part, whose value is {@value}.
	 */
	public static final String HAT = "hat";
	/**
	 * The key of a body model part, whose value is {@value}.
	 */
	public static final String BODY = "body";
	/**
	 * The key of a hat rim model part, whose value is {@value}.
	 */
	public static final String HAT_RIM = "hat_rim";
	/**
	 * The key of a jacket model part, whose value is {@value}.
	 */
	public static final String JACKET = "jacket";
	/**
	 * The key of a top gills model part, whose value is {@value}.
	 */
	public static final String TOP_GILLS = "top_gills";
	/**
	 * The key of a left gills model part, whose value is {@value}.
	 */
	public static final String LEFT_GILLS = "left_gills";
	/**
	 * The key of a right gills model part, whose value is {@value}.
	 */
	public static final String RIGHT_GILLS = "right_gills";
	/**
	 * The key of a root model part, whose value is {@value}.
	 */
	public static final String ROOT = "root";
	/**
	 * The key of a croaking body model part, whose value is {@value}.
	 */
	public static final String CROAKING_BODY = "croaking_body";
	/**
	 * The key of a tongue model part, whose value is {@value}.
	 */
	public static final String TONGUE = "tongue";
	/**
	 * The key of a tongue rl model part, whose value is {@value}.
	 */
	public static final String TONGUE_RL = "tongue_r1";
	/**
	 * The key of a left hand model part, whose value is {@value}.
	 */
	public static final String LEFT_HAND = "left_hand";
	/**
	 * The key of a right hand model part, whose value is {@value}.
	 */
	public static final String RIGHT_HAND = "right_hand";
	/**
	 * The key of a left foot model part, whose value is {@value}.
	 */
	public static final String LEFT_FOOT = "left_foot";
	/**
	 * The key of a right foot model part, whose value is {@value}.
	 */
	public static final String RIGHT_FOOT = "right_foot";
	/**
	 * The key of an eyes model part, whose value is {@value}.
	 */
	public static final String EYES = "eyes";
	/**
	 * The key of a right tendril model part, whose value is {@value}.
	 */
	public static final String RIGHT_TENDRIL = "right_tendril";
	/**
	 * The key of a left tendril model part, whose value is {@value}.
	 */
	public static final String LEFT_TENDRIL = "left_tendril";
	/**
	 * The key of a right ribcage model part, whose value is {@value}.
	 */
	public static final String RIGHT_RIBCAGE = "right_ribcage";
	/**
	 * The key of a left ribcage model part, whose value is {@value}.
	 */
	public static final String LEFT_RIBCAGE = "left_ribcage";
	/**
	 * The key of a bone model part, whose value is {@value}.
	 */
	public static final String BONE = "bone";
}
