package net.minecraft.client.render.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.model.ChickenEntityModel;
import net.minecraft.client.render.entity.model.EntityModelLayers;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.MathHelper;

@Environment(EnvType.CLIENT)
public class ChickenEntityRenderer extends MobEntityRenderer<ChickenEntity, ChickenEntityModel<ChickenEntity>> {
	private static final Identifier TEXTURE = new Identifier("textures/entity/chicken.png");

	public ChickenEntityRenderer(EntityRendererFactory.Context context) {
		super(context, new ChickenEntityModel(context.getPart(EntityModelLayers.CHICKEN)), 0.3F);
	}

	public Identifier getTexture(ChickenEntity chickenEntity) {
		return TEXTURE;
	}

	protected float getAnimationProgress(ChickenEntity chickenEntity, float f) {
		float g = MathHelper.lerp(f, chickenEntity.prevFlapProgress, chickenEntity.flapProgress);
		float h = MathHelper.lerp(f, chickenEntity.prevMaxWingDeviation, chickenEntity.maxWingDeviation);
		return (MathHelper.sin(g) + 1.0F) * h;
	}
}
