package net.minecraft.client.render.entity.feature;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.entity.model.EntityModel;
import net.minecraft.client.render.entity.model.EntityModelLayers;
import net.minecraft.client.render.entity.model.EntityModelLoader;
import net.minecraft.client.render.entity.model.LargeTropicalFishEntityModel;
import net.minecraft.client.render.entity.model.SmallTropicalFishEntityModel;
import net.minecraft.client.render.entity.model.TintableCompositeModel;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.entity.passive.TropicalFishEntity;
import net.minecraft.entity.passive.TropicalFishEntity.Variety;
import net.minecraft.util.Identifier;

@Environment(EnvType.CLIENT)
public class TropicalFishColorFeatureRenderer extends FeatureRenderer<TropicalFishEntity, TintableCompositeModel<TropicalFishEntity>> {
	private static final Identifier KOB_TEXTURE = new Identifier("textures/entity/fish/tropical_a_pattern_1.png");
	private static final Identifier SUNSTREAK_TEXTURE = new Identifier("textures/entity/fish/tropical_a_pattern_2.png");
	private static final Identifier SNOOPER_TEXTURE = new Identifier("textures/entity/fish/tropical_a_pattern_3.png");
	private static final Identifier DASHER_TEXTURE = new Identifier("textures/entity/fish/tropical_a_pattern_4.png");
	private static final Identifier BRINELY_TEXTURE = new Identifier("textures/entity/fish/tropical_a_pattern_5.png");
	private static final Identifier SPOTTY_TEXTURE = new Identifier("textures/entity/fish/tropical_a_pattern_6.png");
	private static final Identifier FLOPPER_TEXTURE = new Identifier("textures/entity/fish/tropical_b_pattern_1.png");
	private static final Identifier STRIPEY_TEXTURE = new Identifier("textures/entity/fish/tropical_b_pattern_2.png");
	private static final Identifier GLITTER_TEXTURE = new Identifier("textures/entity/fish/tropical_b_pattern_3.png");
	private static final Identifier BLOCKFISH_TEXTURE = new Identifier("textures/entity/fish/tropical_b_pattern_4.png");
	private static final Identifier BETTY_TEXTURE = new Identifier("textures/entity/fish/tropical_b_pattern_5.png");
	private static final Identifier CLAYFISH_TEXTURE = new Identifier("textures/entity/fish/tropical_b_pattern_6.png");
	private final SmallTropicalFishEntityModel<TropicalFishEntity> smallModel;
	private final LargeTropicalFishEntityModel<TropicalFishEntity> largeModel;

	public TropicalFishColorFeatureRenderer(
		FeatureRendererContext<TropicalFishEntity, TintableCompositeModel<TropicalFishEntity>> context, EntityModelLoader loader
	) {
		super(context);
		this.smallModel = new SmallTropicalFishEntityModel(loader.getModelPart(EntityModelLayers.TROPICAL_FISH_SMALL_PATTERN));
		this.largeModel = new LargeTropicalFishEntityModel(loader.getModelPart(EntityModelLayers.TROPICAL_FISH_LARGE_PATTERN));
	}

	public void render(
		MatrixStack matrixStack,
		VertexConsumerProvider vertexConsumerProvider,
		int i,
		TropicalFishEntity tropicalFishEntity,
		float f,
		float g,
		float h,
		float j,
		float k,
		float l
	) {
		Variety variety = tropicalFishEntity.getVariant();

		EntityModel<TropicalFishEntity> entityModel = (EntityModel<TropicalFishEntity>)(switch (variety.getSize()) {
			case SMALL -> this.smallModel;
			case LARGE -> this.largeModel;
			default -> throw new IncompatibleClassChangeError();
		});

		Identifier identifier = switch (variety) {
			case KOB -> KOB_TEXTURE;
			case SUNSTREAK -> SUNSTREAK_TEXTURE;
			case SNOOPER -> SNOOPER_TEXTURE;
			case DASHER -> DASHER_TEXTURE;
			case BRINELY -> BRINELY_TEXTURE;
			case SPOTTY -> SPOTTY_TEXTURE;
			case FLOPPER -> FLOPPER_TEXTURE;
			case STRIPEY -> STRIPEY_TEXTURE;
			case GLITTER -> GLITTER_TEXTURE;
			case BLOCKFISH -> BLOCKFISH_TEXTURE;
			case BETTY -> BETTY_TEXTURE;
			case CLAYFISH -> CLAYFISH_TEXTURE;
			default -> throw new IncompatibleClassChangeError();
		};
		float[] fs = tropicalFishEntity.getPatternColorComponents().getColorComponents();
		render(this.getContextModel(), entityModel, identifier, matrixStack, vertexConsumerProvider, i, tropicalFishEntity, f, g, j, k, l, h, fs[0], fs[1], fs[2]);
	}
}
