/*
 * This source file was generated by the Gradle 'init' task
 */
package org.eu.net.pool.mc_plugin

import org.gradle.api.DefaultTask
import org.gradle.api.Project
import org.gradle.api.Plugin
import org.gradle.api.Task
import org.gradle.api.file.Directory
import org.gradle.api.file.RegularFile
import org.gradle.api.provider.ListProperty
import org.gradle.api.provider.MapProperty
import org.gradle.api.provider.Property
import org.gradle.api.provider.Provider
import org.gradle.api.tasks.AbstractCopyTask
import org.gradle.api.tasks.Exec
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.SourceSet
import org.gradle.api.tasks.TaskAction
import org.gradle.kotlin.dsl.get
import org.gradle.language.jvm.tasks.ProcessResources
import java.io.File

typealias PT = context(Project) SourceSet.(String, Pair<String, Task>.(Provider<Directory>) -> Unit) -> Unit

val m4path = System.getenv("PATH").split(':').onEach { println(it) }.first { File("$it/m4").exists() } + "/m4"

class Plugin: Plugin<Project> {
    override fun apply(project: Project) {
        val minecraft_version: String by project.properties
        val serialVersion = minecraft_version.let {
            val (maj, min, pat) = it.toString().split('.') + ".0"
            min.toInt() * 100 + pat.toInt()
        }
        project.buildDir = project.file("build$serialVersion")
        project.extensions.add("minecraft_version", minecraft_version)
        project.extensions.add("serialVersion", serialVersion)
        project.extensions.add("preprocessor", PreprocessorExtension(project, minecraft_version, serialVersion))
    }
}

class PreprocessorExtension(val project: Project, val minecraft_version: String, val serialVersion: Int) {
    val freezeMacrosTask = project.tasks.register<FrozenFile>("freezeMacros", FrozenFile::class.java) {
        macroFiles.add(project.layout.projectDirectory.file("macros.m4"))
        frozenFile.set(project.layout.buildDirectory.file("macros.m4f"))
        globals.put("minecraft_version", serialVersion.toString())
    }.get()
    inline fun <reified T: Task> SourceSet.processTask(lang: String) {
        val inDir = project.layout.projectDirectory.dir("src/$name/$lang")
        val outDir = project.layout.buildDirectory.dir(getTaskName("generated", lang))
        val frozen = project.layout.buildDirectory.file("macros.m4f")
        val task = project.tasks.register(getTaskName("process", lang)) {
            inputs.dir(inDir).optional()
            inputs.file(frozen)
            dependsOn(project.tasks.named("freezeMacros"))
            outputs.dir(outDir)
            onlyIf { project.file(inDir).exists() }
            doLast {
                project.fileTree(inDir).files.forEach {
                    project.file("${outDir.get()}/${it.relativeTo(inDir.asFile)}").parentFile.mkdirs()
                    project.exec {
                        commandLine(m4path, "-R", frozen.get().asFile.path, it.path)
                        standardOutput = project.file("${outDir.get()}/${it.relativeTo(inDir.asFile)}").outputStream()
                    }
                }
            }
        }.get()
        project.tasks.named<T>(getCompileTaskName(lang), T::class.java) {
            inputs.property("minecraft_version", project.extensions["serialVersion"])
            dependsOn(task)
            doFirst {
                try {
                    T::class.java.getMethod("setSource", Object::class.java).invoke(this@named, outDir)
                } catch (e: NoSuchMethodException) {
                    T::class.java.getMethod("setSource", Array<Object>::class.java).invoke(this@named, arrayOf(outDir))
                }
            }
        }
    }

    fun AbstractCopyTask.fabricMod(id: String, version: String, action: FabricMod.() -> Unit) {
        val mod = FabricMod(id, version)
        mod.action()
        from(project.resources.text.fromString(mod.toString())) { rename { "fabric.mod.json" } }
    }
}

abstract class FrozenFile: DefaultTask() {
    @get:InputFiles val macroFiles: ListProperty<RegularFile> = project.objects.listProperty(RegularFile::class.java)
    @get:OutputFile val frozenFile: Property<RegularFile> = project.objects.fileProperty()
    @get:Input val globals: MapProperty<String, String> = project.objects.mapProperty(String::class.java, String::class.java)
    init {
        inputs.files(macroFiles)
        inputs.property("globals", globals)
        outputs.file(frozenFile)
    }
    @TaskAction
    fun run() {
        project.exec {
            val args = mutableListOf(m4path, "-F", frozenFile.get().asFile.path)
            globals.get().forEach { k, v -> args.add("-D$k=$v") }
            macroFiles.get().forEach { args.add(it.asFile.path) }
            commandLine = args
        }
    }
}

