package org.eu.net.pool.p2.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.apace100.apoli.component.PowerHolderComponent;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import org.eu.net.pool.p2.FoodHUDPower;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(class_329.class)
public class InGameHudMixin {
    @ModifyArg(
            method = "renderStatusBars",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V"),
            slice = @Slice(
                    from = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;getHungerManager()Lnet/minecraft/entity/player/HungerManager;"),
                    to = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;getAir()I")
            )
    )
    class_2960 modifyTexture(class_2960 texture, @Local class_1657 player) {
        var powers = player.getComponent(PowerHolderComponent.KEY).getPowers(FoodHUDPower.class);
        if (powers.isEmpty()) {
            return texture;
        } else {
            return powers.get(0).texture();
        }
    }
}
