package org.eu.net.pool.p2

import io.github.apace100.apoli.power.{Power, PowerType}
import io.github.apace100.apoli.power.factory.PowerFactory
import io.github.apace100.apoli.registry.ApoliRegistries
import io.github.apace100.calio.data.{SerializableData, SerializableDataTypes}
import net.minecraft.entity.LivingEntity
import net.minecraft.registry.Registry
import net.minecraft.util.Identifier

// changequote(<<, >>)

/**
 * `p4:ignore_for_sleeping_checks`
 *
 * Makes a player ignored for the purposes of sleep quota.
 */

case class SleepIgnorePower()(typ: PowerType[SleepIgnorePower], entity: LivingEntity) extends Power(typ, entity)
object SleepIgnorePower:
  val id = Identifier.of("p4", "ignore_for_sleeping_checks")
  given PowerFactory[SleepIgnorePower] = new PowerFactory[SleepIgnorePower](id, SerializableData(), _ => SleepIgnorePower.apply())

/**
 * `p4:customize_food`
 *
 * Redirects draws to a player's hunger bar to another texture.
 *
 * @param texture The path to a texture to render. Minecraft's default is `minecraft:textures/gui/icons.png`.
 */

case class FoodHUDPower(texture: Identifier)(typ: PowerType[FoodHUDPower], entity: LivingEntity) extends Power(typ, entity)
object FoodHUDPower:
  val id = Identifier.of("p4", "customize_food")
  given PowerFactory[FoodHUDPower] = new PowerFactory[FoodHUDPower](id, SerializableData().add("texture", SerializableDataTypes.IDENTIFIER), data => FoodHUDPower(data.getId("texture")))

def registerPower[T <: Power: PowerFactory as f](ident: Identifier) =
  Registry.register(ApoliRegistries.POWER_FACTORY, ident, f)

def init(): Unit =
  registerPower[SleepIgnorePower](SleepIgnorePower.id)
  registerPower[FoodHUDPower](FoodHUDPower.id)