package org.eu.net.pool.mutationkit.mixin

import net.minecraft.entity.player.PlayerEntity
import org.eu.net.pool.mutationkit.{MutationAccess, MutationInstance, MutationStorage, MutationType}
import org.spongepowered.asm.mixin.injection.{At, Inject}
import org.spongepowered.asm.mixin.{Mixin, Unique}

import scala.language.experimental.erasedDefinitions

@Mixin(value = Array(classOf[PlayerEntity]))
private [mixin] class PlayerEntityMixin extends MutationAccess:
  this: PlayerEntity =>

  override def addMutation[T](typ: MutationType[T], data: T, persist: Boolean): Boolean =
    val c: MutationStorage = getComponent(MutationStorage.key)
    if persist then
      if (c.permMutations isDefinedAt typ) || c.permMutations.keys.exists(typ.conflictSet) then
        false
      else
        c.permMutations += typ -> data
        syncComponent(MutationStorage.key)
        true
    else
      if (c.tempMutations isDefinedAt typ) || c.tempMutations.keys.exists(typ.conflictSet) then
        false
      else
        c.tempMutations += typ -> data
        typ.onApplied(this, data)
        syncComponent(MutationStorage.key)
        true
  override def replaceMutation[T](typ: MutationType[T], data: T, persist: Boolean): (Boolean, Option[T]) =
    val c: MutationStorage = getComponent(MutationStorage.key)
    typ match
      case c.permMutations(old: T) if persist =>
        c.permMutations += typ -> data
        syncComponent(MutationStorage.key)
        (true, Some(old))
      case c.tempMutations(old: T) if !persist =>
        typ.onRemoved(this, old)
        c.tempMutations += typ -> data
        typ.onApplied(this, data)
        syncComponent(MutationStorage.key)
        (true, Some(old))
      case _ => (addMutation(typ, data, persist), None)
  override def setMutation[T](typ: MutationType[T], data: T, persist: Boolean): Unit =
    val c: MutationStorage = getComponent(MutationStorage.key)
    if persist then
      c.permMutations += typ -> data
    else
      typ match
        case c.tempMutations(d: T) => typ.onRemoved(this, d)
        case _ => {}
      c.tempMutations += typ -> data
      typ.onApplied(this, data)
  override def removeMutation[T](typ: MutationType[T], persist: Boolean): Boolean =
    val c: MutationStorage = getComponent(MutationStorage.key)
    if persist then
      if c.permMutations isDefinedAt typ then
        c.permMutations -= typ
        syncComponent(MutationStorage.key)
        true
      else
        false
    else
      if c.tempMutations isDefinedAt typ then
        typ.onRemoved(this, c.tempMutations(typ).asInstanceOf)
        c.tempMutations -= typ
        syncComponent(MutationStorage.key)
        true
      else
        false
  override def findMutations(persist: Boolean): Set[MutationType[?]] =
    val c: MutationStorage = getComponent(MutationStorage.key)
    if persist then
      c.permMutations.keySet
    else
      c.tempMutations.keySet
  override def findMutation[T](typ: MutationType[T], persist: Boolean): Option[T] =
    val c: MutationStorage = getComponent(MutationStorage.key)
    typ match
      case c.tempMutations(d: T) if !persist => Some(d)
      case c.permMutations(d: T) if persist => Some(d)
      case _ => None
