package org.eu.net.pool.mutationkit.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.class_1297;
import net.minecraft.class_1628;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5568;
import org.eu.net.pool.mutationkit.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1297.class)
public abstract class EntityMixin implements class_5568 {
    @Shadow private class_1937 world;
    @Shadow public boolean horizontalCollision;

    @Shadow private class_243 velocity;

    @Shadow public abstract void setVelocity(double x, double y, double z);

    @ModifyReturnValue(method = "getJumpVelocityMultiplier", at = @At("TAIL")) float getJumpVelocityMultiplier(float original) { return (Object) this instanceof MutationAccess ent && ent.findMutation(JumpPower$.MODULE$, false) instanceof scala.Some<?> some ? (float) (original + (Double) some.value()) : original; }
    @WrapMethod(method = "isGlowing") boolean isGlowing(Operation<Boolean> original) { return original.call() || world.field_9236 && this instanceof MutationAccess m && m.findMutation(Glowing$.MODULE$, false).isDefined(); }
    @ModifyReturnValue(method = "getStepHeight", at = @At("TAIL")) float getStepHeight(float original) { return this instanceof MutationAccess acc ? acc.findMutation(StepHeight$.MODULE$, false).getOrElse(() -> 0.0).floatValue() + original : original; }
    @Inject(method = "tick", at = @At("HEAD")) void preTick(CallbackInfo ci) {
        if (horizontalCollision && this instanceof MutationAccess m && !((Object) this instanceof class_1628) && m.findMutation(Spiderlike$.MODULE$, false).isDefined()) {
            if(velocity.field_1351 < 0.2) {
                setVelocity(velocity.field_1352, 0.2, velocity.field_1350);
            }
        }
    }
}
