package org.eu.net.pool.mutationkit

import net.minecraft.entity.player.PlayerEntity
import net.minecraft.server.network.ServerPlayerEntity

class EffectManager[C <: MutationAccess, T](extract: C => T):
    case class Row[D](ty: MutationType[D], pred: T => Boolean, gen: C => D)
    class System(rows: Row[?]*):
        def apply(subject: C) =
            val ctx: T = extract(subject)
            val poss = rows.filter(_.pred(ctx))
            for case Row(ty, _, gen) <- poss do
                subject.addMutation(ty, gen(subject))