package org.net.eu.pool.mica.mixin; // seeded

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.net.eu.pool.mica.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_5329;
@Mixin(class_5329.class)
public class BlockCollisionSpliteratorMixin {
    @WrapOperation(method = "computeNext", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/ShapeContext;getCollisionShape(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/CollisionView;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/shape/VoxelShape;"))
    class_265 addRuneShapes(class_3726 instance, class_2680 blockState, class_1941 collisionView, class_2338 blockPos, Operation<class_265> original) {
        class_265 orig = original.call(instance, blockState, collisionView, blockPos);
        ArrayList<class_265> shapes = new ArrayList<>();
        if (collisionView instanceof class_1937 world) {
            for (int i = 0; i < 768; i++) {
                AbstractRuneStorage storage = AbstractRuneStorage.get(world, i);
                if (storage.apply(blockPos) != EmptyRune$.MODULE$)
                    shapes.add(RuneShift$.MODULE$.shapeCache()[i]);
            }
            if (!shapes.isEmpty()) {
                class_265 merged = class_259.method_17786(class_259.method_1073(), shapes.toArray(new class_265[0])).method_64034(blockPos.method_46558());
                return class_259.method_1084(orig, merged);
            }
        }
        return orig;
    }
}