package org.eu.net.pool.hexmu.mixin;

import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.common.casting.actions.eval.OpEval;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.apache.commons.codec.binary.Hex;
import org.eu.net.pool.hexmu.HexMuKt;
import org.eu.net.pool.hexmu.IotaDuck;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import ram.talia.moreiotas.api.casting.iota.StringIota;

@Mixin(value = Iota.class, remap = false)
public class IotaMixin implements IotaDuck {
    @Unique
    private Iota hexmu$inscription;
    @Unique
    private Iota hexmu$functor;

    @Override
    public @Nullable Iota hexmu$getInscription() {
        return hexmu$inscription;
    }

    @Override
    public @Nullable Iota hexmu$getFunctor() {
        return hexmu$functor;
    }

    @Override
    public void hexmu$setInscription(@Nullable Iota iota) {
        hexmu$inscription = iota;
    }

    @Override
    public void hexmu$setFunctor(@Nullable Iota iota) {
        hexmu$functor = iota;
    }

    @WrapMethod(method = "executable")
    public boolean executable(Operation<Boolean> original) {
        return (hexmu$functor != null && hexmu$functor.executable()) || original.call();
    }

    @WrapMethod(method = "execute")
    public CastResult execute(CastingVM vm, class_3218 world, SpellContinuation continuation, Operation<CastResult> original) {
        if (hexmu$functor != null) return HexMuKt.invokeWithFunctor(vm, world, continuation, hexmu$functor);
        else return original.call(vm, world, continuation);
    }
    
    @WrapMethod(method = "display")
    public class_2561 display(Operation<class_2561> original) {
        class_2561 text = original.call();
        if (hexmu$inscription != null) {
            if (hexmu$inscription instanceof StringIota s) {
                text = class_2561.method_43470(s.getString()).method_27693(": ").method_10852(text).method_10862(text.method_10866());
            } else {
                text = class_2561.method_43470("").method_10852(hexmu$inscription.display().method_27661().method_27693(": ")).method_10852(text).method_10862(text.method_10866());
            }
        }
        if (hexmu$functor != null) {
            class_5250 m = text instanceof class_5250 m_ ? m_ : (class_5250) (text = text.method_27661());
            m.method_10852(class_2561.method_43470("…?").method_27694(s -> s.method_36139(hexmu$functor.getType().color())));
        }
        return text;
    }
}
