package org.eu.net.pool.hexmu.mixin;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.eu.net.pool.hexmu.RawIotaHolderItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Inject;

@Mixin(value = ItemSpellbook.class, remap = false)
public abstract class ItemSpellbookMixin implements RawIotaHolderItem {
    @Shadow
    @Override
    public @Nullable class_2487 readIotaTag(@NotNull class_1799 itemStack) { return null; }

    @Shadow
    @Override
    public boolean writeable(class_1799 itemStack) { return false; }

    @Shadow
    @Override
    public boolean canWrite(class_1799 itemStack, @Nullable Iota iota) { return false; }

    @Shadow
    @Override
    public void writeDatum(class_1799 itemStack, @Nullable Iota iota) {}

    @Shadow
    public static boolean isSealed(class_1799 stack) {
        return false;
    }

    @Shadow public static String TAG_SEALED;

    @Shadow public static String TAG_PAGES;

    @Shadow public abstract int getPage(class_1799 stack, int ifEmpty);

    @Override
    public void hexmu$writeIotaTag(@NotNull class_1799 $this$iotaTag, @Nullable class_2487 nbtCompound) {
        if (nbtCompound == null || !isSealed($this$iotaTag)) {
            int idx = getPage($this$iotaTag, 1);
            String key = String.valueOf(idx);
            class_2487 pages = NBTHelper.getCompound($this$iotaTag, TAG_PAGES);
            if (pages != null) {
                if (nbtCompound == null) {
                    pages.method_10551(key);
                    NBTHelper.remove(NBTHelper.getCompound($this$iotaTag, TAG_SEALED), key);
                } else {
                    pages.method_10566(key, nbtCompound);
                }

                if (pages.method_33133()) {
                    NBTHelper.remove($this$iotaTag, TAG_PAGES);
                }
            } else if (nbtCompound != null) {
                NBTHelper.getOrCreateCompound($this$iotaTag, TAG_PAGES).method_10566(key, nbtCompound);
            } else {
                NBTHelper.remove(NBTHelper.getCompound($this$iotaTag, TAG_SEALED), key);
            }

        }
    }
}
