package org.eu.net.pool.hexmu.client

import at.petrak.hexcasting.datagen.tag.HexActionTagProvider
import kotlinx.coroutines.future.asCompletableFuture
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator
import net.minecraft.client.MinecraftClient
import org.eu.net.pool.common_curses.client.HotbarRendering
import org.eu.net.pool.common_curses.client.useChatEvent
import org.eu.net.pool.hexmu.playerStateComponent
import org.eu.net.pool.hexmu.uwufy
import poollovernathan.fabric.DataContext

fun client() {
    useChatEvent.register {
        MinecraftClient.getInstance().player?.getComponent(playerStateComponent)?.silence == true
    }
}

fun datagen(gen: FabricDataGenerator) {
    DataContext(gen).run {
		withRegistry { it, reg ->
			object: HexActionTagProvider(it, reg.asCompletableFuture()) {

			}
		}
    }
}

fun transformMessage(content: String): String = content
	.let {
		if (MinecraftClient.getInstance().player?.getComponent(playerStateComponent)?.uwuify == true)
			content.uwufy()
		else
			content
	}