package org.eu.net.pool.hexmu.mixin;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.NullIota;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import org.eu.net.pool.hexmu.Actions;
import org.eu.net.pool.hexmu.IotaDuck;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import ram.talia.moreiotas.api.casting.iota.StringIota;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;

@Mixin(value = IotaType.class, remap = false)
public abstract class IotaTypeMixin {
    @Shadow
    public static class_2487 serialize(Iota iota) { return null; }

    @Shadow
    public static @NotNull class_2561 getDisplay(class_2487 tag) {
        return null;
    }

    @Shadow
    public static @Nullable IotaType<?> getTypeFromTag(class_2487 tag) {
        return null;
    }

    @WrapMethod(method = "serialize", remap = true)
    private static class_2487 serialize(Iota iota, Operation<class_2487> original) {
        class_2487 tag = original.call(iota);
        if (iota instanceof IotaDuck duck) {
            if (duck.hexmu$getFunctor() != null)
                tag.method_10566(Actions.FUNCTOR_KEY, serialize(duck.hexmu$getFunctor()));
            if (duck.hexmu$getInscription() != null)
                tag.method_10566(Actions.INSCRIPTION_KEY, serialize(duck.hexmu$getInscription()));
            if (duck.hexmu$getExpiry() != 0)
                tag.method_10544(Actions.EXPIRY_KEY, duck.hexmu$getExpiry());
            if (!duck.hexmu$getAnnotations().isEmpty()) {
                class_2499 c = new class_2499();
                tag.method_10566(Actions.ANNOTATION_KEY, c);
                for (var entry: duck.hexmu$getAnnotations().entrySet()) {
                    class_2487 r = new class_2487();
                    r.method_10566("k", serialize(entry.getKey()));
                    r.method_10566("v", serialize(entry.getValue()));
                    c.add(r);
                }
            }
        }
        return tag;
    }

    @WrapOperation(method = {"getDisplay", "getDisplayWithMaxWidth"}, at = @At(value = "INVOKE", target = "Lat/petrak/hexcasting/api/casting/iota/IotaType;display(Lnet/minecraft/nbt/NbtElement;)Lnet/minecraft/text/Text;", remap = true), remap = false, require = 2)
    private static class_2561 decorateDisplay(IotaType instance, class_2520 nbtElement, Operation<class_2561> original, @Local(argsOnly = true) class_2487 c) {
        class_2561 text = original.call(instance, nbtElement);
        if (c.method_10580(Actions.INSCRIPTION_KEY) instanceof class_2487 inscr) {
            if (Objects.equals(inscr.method_10558(HexIotaTypes.KEY_TYPE), "moreiotas:string")) {
                text = class_2561.method_43470(inscr.method_10558(HexIotaTypes.KEY_DATA)).method_27693(": ").method_10852(text).method_10862(text.method_10866());
            } else {
                text = class_2561.method_43470("").method_10852(getDisplay(c).method_27661().method_27693(": ")).method_10852(text).method_10862(text.method_10866());
            }
        }
        if (c.method_10545(Actions.FUNCTOR_KEY)) {
            class_5250 m = text instanceof class_5250 m_ ? m_ : (class_5250) (text = text.method_27661());
            m.method_10852(class_2561.method_43470("...?").method_27694(s -> s.method_27703(Objects.requireNonNullElse(getTypeFromTag(c.method_10562(Actions.FUNCTOR_KEY)), instance).color())));
        }
        return text;
    }

    @Shadow @NotNull public static Iota deserializeIota(class_2487 tag, class_3218 world) { return null; }

    @WrapMethod(method = "deserializeIota(Lnet/minecraft/nbt/NbtCompound;Lnet/minecraft/server/world/ServerWorld;)Lat/petrak/hexcasting/api/casting/iota/Iota;", remap = true)
    private static Iota deserializeIota(class_2487 tag, class_3218 world, Operation<Iota> original) {
        Iota iota = original.call(tag, world);
        if (iota instanceof IotaDuck duck) {
            duck.hexmu$setServer(world.method_8503());
            if (tag.method_10573(Actions.INSCRIPTION_KEY, class_2520.field_33260))
                duck.hexmu$setInscription(IotaType.deserializeIota(tag.method_10562(Actions.INSCRIPTION_KEY), world));
            if (tag.method_10573(Actions.FUNCTOR_KEY, class_2520.field_33260))
                duck.hexmu$setFunctor(IotaType.deserializeIota(tag.method_10562(Actions.FUNCTOR_KEY), world));
            if (tag.method_10573(Actions.EXPIRY_KEY, class_2520.field_33254)) {
                duck.hexmu$setExpiry(tag.method_10537(Actions.EXPIRY_KEY));
                if (duck.hexmu$getExpiry() < world.method_8503().method_30002().method_8510()) return new NullIota();
            }
            if (tag.method_10573(Actions.ANNOTATION_KEY, class_2520.field_33259)) {
                class_2499 l = tag.method_10554(Actions.ANNOTATION_KEY, class_2520.field_33260);
                l.forEach(c -> { if (c instanceof class_2487 t) duck.hexmu$getAnnotations().put(deserializeIota(t.method_10562("k"), world), deserializeIota(t.method_10562("v"), world)); });
            }
        }
        return iota;
    }
}
