package org.eu.net.pool.hexmu.client

import at.petrak.hexcasting.datagen.tag.HexActionTagProvider
import kotlinx.coroutines.future.asCompletableFuture
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator
import net.minecraft.client.MinecraftClient
import org.eu.net.pool.common_curses.TextManipulator
import org.eu.net.pool.common_curses.client.modifyChatEvent
import org.eu.net.pool.common_curses.client.modifyTextRenderingEvent
import org.eu.net.pool.common_curses.client.useChatEvent
import org.eu.net.pool.hexmu.TextEffect
import org.eu.net.pool.hexmu.playerStateComponent
import poollovernathan.fabric.DataContext

fun client() {
    useChatEvent.register {
        val c = MinecraftClient.getInstance().player?.getComponent(playerStateComponent)
		c?.chatManip == TextEffect.EMPTY || c?.textManip == TextEffect.EMPTY
    }
    modifyChatEvent.register {
        val c = MinecraftClient.getInstance().player?.getComponent(playerStateComponent)
        c?.chatManip?.manip ?: TextManipulator.None
    }
    modifyTextRenderingEvent.register {
        val c = MinecraftClient.getInstance().player?.getComponent(playerStateComponent)
        c?.textManip?.manip ?: TextManipulator.None
    }
}

fun datagen(gen: FabricDataGenerator) {
    DataContext(gen).run {
		withRegistry { it, reg ->
			object: HexActionTagProvider(it, reg.asCompletableFuture()) {

			}
		}
    }
}
