@file:OptIn(ExperimentalUuidApi::class)

package org.eu.net.pool.hexmu
//
import at.petrak.hexcasting.api.casting.ActionRegistryEntry
import at.petrak.hexcasting.api.casting.RenderedSpell
import at.petrak.hexcasting.api.casting.castables.ConstMediaAction
import at.petrak.hexcasting.api.casting.castables.SpellAction
import at.petrak.hexcasting.api.casting.eval.CastResult
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment
import at.petrak.hexcasting.api.casting.eval.ResolvedPatternType
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation
import at.petrak.hexcasting.api.casting.getPlayer
import at.petrak.hexcasting.api.casting.iota.Iota
import at.petrak.hexcasting.api.casting.iota.IotaType
import at.petrak.hexcasting.api.casting.iota.NullIota
import at.petrak.hexcasting.api.casting.math.HexAngle
import at.petrak.hexcasting.api.casting.math.HexDir
import at.petrak.hexcasting.api.casting.math.HexPattern
import at.petrak.hexcasting.api.casting.mishaps.MishapInternalException
import at.petrak.hexcasting.api.item.IotaHolderItem
import at.petrak.hexcasting.api.misc.MediaConstants
import at.petrak.hexcasting.api.utils.getUUID
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf
import at.petrak.hexcasting.common.casting.actions.eval.OpEval
import at.petrak.hexcasting.common.lib.HexSounds
import dev.onyxstudios.cca.api.v3.component.Component
import dev.onyxstudios.cca.api.v3.component.ComponentKey
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy
import kotlinx.serialization.descriptors.PolymorphicKind
import net.minecraft.entity.player.PlayerEntity
import net.minecraft.item.Item
import net.minecraft.item.ItemStack
import net.minecraft.nbt.NbtCompound
import net.minecraft.registry.Registry
import net.minecraft.server.world.ServerWorld
import net.minecraft.sound.SoundCategory
import net.minecraft.util.ActionResult
import net.minecraft.util.Identifier
import net.minecraft.util.math.BlockPos
import net.minecraft.world.World
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable
import poollovernathan.fabric.RegistryWrapper
import java.util.UUID
import kotlin.uuid.ExperimentalUuidApi
import kotlin.uuid.Uuid
import kotlin.uuid.toJavaUuid
import kotlin.uuid.toKotlinUuid

const val modid = "hexmu"

val xplat = at.petrak.hexcasting.xplat.IXplatAbstractions.INSTANCE!!
val hexActions = xplat.actionRegistry

object Patterns {
    val createPocket = HexPatternBuilder.southeast.a.d.a.d.d.w.w.d.w.w.d.d.a.a.d.d.w()
    val uwuify = HexPatternBuilder.northeast.q.a.q.w.a.d.a.w.q.a.q()
    val inscribe = HexPatternBuilder.southwest.a.w.q.q.q.q.q.a.e.w.e.a.q.q.q.q.q.w.a()
    val inscription = HexPatternBuilder.northwest.e.e.e.e.e.a.a.q.e.w.e.q.a.a.e.e.e.e.e()
    val functor = HexPatternBuilder.east.d.e.e.e.e.e.q.q.a.e.d()
    val food = HexPatternBuilder.east.w.w.a.q.a.w.a.e.a.w.q.q.e.a.w.a()
    val silence = HexPatternBuilder.east.w.a.q.a.a()
    val unsilence = HexPatternBuilder.east.w.a.q.a.e()
    val conjureDimension = HexPatternBuilder.east
        .q.w.q.w.q.w.q.w.q.w.q.a
        .q.d.q.d.q.d.q.d.q.d.d.a.d.a.a.d.a.a.d.e
        .w.e.e.e.m.m.m.m.m
    val dismissDimension = HexPatternBuilder.east
        .w.w.w.d.e.d.w.w.w.a.w.q.w.a.q
        .a.w.q.w.q.q.d.q.q.a.a.q.a.e.w
        .w.d.e.d.w.w.w.d.d.e.d.a.q.d.q

    inline val HexPatternBuilder.m get() = a.e.e.e
}

///*
////abstract class PocketContents(val id: Identifier) {
////    open fun CastingState.deposit(pos: BlockPos): Boolean {
////        sound = sound.greaterOf(HexEvalSounds.MISHAP)
////        return false
////    }
////    open fun CastingState.tryDeposit(pos: BlockPos) = also<PocketContents> {
////        sound = sound.greaterOf(HexEvalSounds.MISHAP)
////    }
////    open val isTruthy: Boolean get() = true
////    open fun CastingState.release() {
////        // simply voided
////        sound = sound.greaterOf(HexEvalSounds.MISHAP)
////    }
////    abstract fun writeNBT(c: NbtCompound)
////    protected fun writeType(c: NbtCompound) {
////        c.putString("type", id.toString())
////    }
////    abstract fun display(): Text
////
////    companion object {
////        val types = RegistryWrapper<(NbtCompound) -> PocketContents>(Identifier(modid, "pocket_contents"), Identifier(modid, "opaque"))
////        fun readNBT(c: NbtCompound) =
////            c.getString("type")?.let(Identifier::tryParse)?.let(types::get)?.let { it(c).apply { check(id == it) } } ?: Garbage(c)
////    }
////
////    object Empty: PocketContents(Identifier(modid, "empty")) {
////        override val isTruthy get() = false
////        override fun CastingState.deposit(pos: BlockPos) = true
////        override fun CastingState.tryDeposit(pos: BlockPos) = Empty
////        override fun CastingState.release() {}
////        override fun writeNBT(c: NbtCompound) {
////            writeType(c)
////        }
////
////        override fun equals(other: Any?) = other == Empty
////    }
////    class Garbage(val data: NbtCompound): PocketContents(Identifier(modid, "garbage")) {
////        override val isTruthy = true
////        override fun writeNBT(c: NbtCompound) {
////            c.copyFrom(data)
////        }
////    }
////    data class Item(val variant: ItemVariant, val count: Long): PocketContents(Identifier(modid, "item")) {
////        override val isTruthy get() = count != 0L
////        override fun CastingState.deposit(pos: BlockPos): Boolean {
////            ItemStorage.SIDED.find(world, pos, null)?.let {
////                Transaction.openOuter().use { t ->
////                    if (it.insert(variant, count, t) == count) {
////                        sound = sound.greaterOf(HexEvalSounds.SPELL)
////                        t.commit()
////                        return true
////                    }
////                }
////            }
////            sound = sound.greaterOf(HexEvalSounds.MISHAP)
////            return false
////        }
////
////        override fun writeNBT(c: NbtCompound) {
////            writeType(c)
////            assert(variant is ItemVariantImpl)
////            c.putString("item", Registries.ITEM.getId(variant.item).toString())
////            c.putLong("size", count)
////            if (variant.nbt != null) {
////                c.put("tag", variant.nbt)
////            }
////        }
////        override fun CastingState.tryDeposit(pos: BlockPos): PocketContents{
////            ItemStorage.SIDED.find(world, pos, null)?.let {
////                Transaction.openOuter().use { t ->
////                    val n = it.insert(variant, count, t)
////                    if (n > 0) {
////                        sound = sound.greaterOf(HexEvalSounds.SPELL)
////                        t.commit()
////                        return if (n == count) Empty
////                        else Item(variant, count - n)
////                    }
////                }
////            }
////            sound = sound.greaterOf(HexEvalSounds.MISHAP)
////            return this@Item
////        }
////
////        override fun CastingState.release() {
////            sound = sound.greaterOf(HexEvalSounds.SPELL)
////        }
////    }
////
////    // TODO:
////    //  data class Fluid(val variant: FluidVariant, val count: Long): PocketContents()
////    //  data class Energy(val amount: Long): PocketContents()
////}
////
////class PocketIota(val contents: PocketContents): Iota(Type, contents) {
////    override fun isTruthy() = contents.isTruthy
////    override fun toleratesOther(that: Iota?) = that is PocketIota && contents == that.contents
////    override fun serialize() = NbtCompound().also(contents::writeNBT)
////    object Type: IotaType<PocketIota>() {
////        override fun deserialize(
////            tag: NbtElement?,
////            world: ServerWorld?
////        ): PocketIota? = (tag as? NbtCompound)?.let(PocketContents::readNBT)?.let(::PocketIota)
////
////        // this is HORRIBLY inefficient
////        override fun display(tag: NbtElement?): Text? = deserialize(tag, null)?.display()
////
////        override fun color(): Int {
////            TODO("Not yet implemented")
////        }
////    }
////}
//*/
//
object Actions {
//    val createPocket = CastingState.wrapAction {
//        val stack = stack.toMutableList()
//        val target = stack.removeLast()
//        when (target) {
//            is PocketIota -> {
//                // no use re-pocketing
//                return@wrapAction
//            }
//        }
//    }
    val uwuify = object: SpellAction {
        override val argc = 1

        override fun execute(
            args: List<Iota>,
            env: CastingEnvironment
        ): SpellAction.Result {
            val player = args.getPlayer(0, argc)
            val component = player.getComponent(playerStateComponent)
            return SpellAction.Result(object: RenderedSpell {
                override fun cast(env: CastingEnvironment) {
                    component.uwuify = true
                    playerStateComponent.sync(player)
                }
            }, if (component.uwuify) 0 else MediaConstants.CRYSTAL_UNIT * 3, listOf())
        }
    }

    const val INSCRIPTION_KEY = "$modid:inscription"
    const val FUNCTOR_KEY = "$modid:functor"

    val inscribe = object: ConstMediaAction {
        override val argc = 1

        override fun execute(
            args: List<Iota>,
            env: CastingEnvironment
        ): List<Iota> {
            val (arg) = args
            check(arg is IotaDuck)
            return listOf(arg.inscription ?: NullIota())
        }
    }

    val inscription = object: ConstMediaAction {
        override val argc = 2

        override fun execute(
            args: List<Iota>,
            env: CastingEnvironment
        ): List<Iota> {
            val (target, label) = args
            check(target is IotaDuck)
            println("Planning to inscribe $target with $label")
            // This feels evil.
            val data = IotaType.serialize(target)
            println("Serialized data: $data")
            if (label is NullIota) {
                data.remove(INSCRIPTION_KEY)
                println("Removed inscription")
            } else {
                data.put(INSCRIPTION_KEY, IotaType.serialize(label))
                println("Added inscription")
            }
            println("New data: $data")
            val new = IotaType.deserializeIota(data, env.world)
            return listOf(new)
        }
    }

    val functor = object: ConstMediaAction {
        override val argc = 2

        override fun execute(
            args: List<Iota>,
            env: CastingEnvironment
        ): List<Iota> {
            val (target, label) = args
            check(target is IotaDuck)
            // This feels evil x2
            val data = IotaType.serialize(target)
            if (label is NullIota) {
                data.remove(FUNCTOR_KEY)
            } else {
                data.put(FUNCTOR_KEY, IotaType.serialize(label))
            }
            return listOf(IotaType.deserializeIota(data, env.world))
        }
    }

    val silence = object: SpellAction {
        override val argc = 1

        override fun execute(args: List<Iota>, env: CastingEnvironment): SpellAction.Result {
            val player = args.getPlayer(0, argc)
            val state = player.getComponent(playerStateComponent)
            return SpellAction.Result(object: RenderedSpell {
                override fun cast(env: CastingEnvironment) {
                    state.silence = true
                    state.silenceCause = env.castingEntity?.uuid?.toKotlinUuid() ?: Uuid.NIL
                }
            }, if (state.silence) 0 else MediaConstants.QUENCHED_BLOCK_UNIT, listOf())
        }
    }

    val unsilence = object: SpellAction {
        override val argc = 1

        override fun execute(args: List<Iota>, env: CastingEnvironment): SpellAction.Result {
            val player = args.getPlayer(0, argc)
            val state = player.getComponent(playerStateComponent)
            return SpellAction.Result(object: RenderedSpell {
                override fun cast(env: CastingEnvironment) {
                    state.silence = false
                    state.silenceCause = Uuid.NIL
                }
            }, if (!state.silence) 0 else if (env.castingEntity?.uuid?.toKotlinUuid() == state.silenceCause) MediaConstants.SHARD_UNIT * 3 else MediaConstants.QUENCHED_BLOCK_UNIT * 32, listOf())
        }
    }
}

@Suppress("INAPPLICABLE_JVM_NAME")
interface IotaDuck {
    @get:JvmName("hexmu\$getInscription")
    @set:JvmName("hexmu\$setInscription")
    var inscription: Iota?
    @get:JvmName("hexmu\$getFunctor")
    @set:JvmName("hexmu\$setFunctor")
    var functor: Iota?
}

fun id(value: String) = Identifier(modid, value)
data class PlayerState
@JvmOverloads constructor(
    val player: PlayerEntity,
    var uwuify: Boolean = false,
    var uwuifyCause: Uuid = Uuid.NIL,
    var silence: Boolean = false,
    var silenceCause: Uuid = Uuid.NIL,
): Component, AutoSyncedComponent {
    override fun readFromNbt(p0: NbtCompound) {
        uwuify = p0.getBoolean("uwuify")
        uwuifyCause = p0.getUUID("uwuifyCause")?.toKotlinUuid() ?: Uuid.NIL
        silence = p0.getBoolean("silence")
        silenceCause = p0.getUUID("silenceCause")?.toKotlinUuid() ?: Uuid.NIL
    }

    override fun writeToNbt(p0: NbtCompound) {
        p0.putBoolean("uwuify", uwuify)
        p0.putUuid("uwuifyCause", uwuifyCause.toJavaUuid())
        p0.putBoolean("silence", silence)
        p0.putUuid("silenceCause", silenceCause.toJavaUuid())
    }
}

val playerStateComponent: ComponentKey<PlayerState> by lazy {
    ComponentRegistry.getOrCreate(id("player_state"), PlayerState::class.java)
}
fun init() {
    Registry.register(hexActions, id("uwuify"), ActionRegistryEntry(Patterns.uwuify, Actions.uwuify))
    Registry.register(hexActions, id("inscribe"), ActionRegistryEntry(Patterns.inscribe, Actions.inscribe))
    Registry.register(hexActions, id("inscription"), ActionRegistryEntry(Patterns.inscription, Actions.inscription))
    Registry.register(hexActions, id("functor"), ActionRegistryEntry(Patterns.functor, Actions.functor))
}

fun EntityComponentFactoryRegistry.initComponents() {
    registerForPlayers(playerStateComponent, ::PlayerState, RespawnCopyStrategy.CHARACTER)
}

fun invokeWithFunctor(
    vm: CastingVM,
    world: ServerWorld,
    cont: SpellContinuation,
    functor: Iota,
): CastResult {
    val (image, effects, newCont, sound) = OpEval.exec(vm.env, vm.image, cont, vm.image.stack.toMutableList(), functor)
    return CastResult(
        functor,
        newCont,
        image,
        effects,
        ResolvedPatternType.EVALUATED,
        sound,
    )
}

class HexPatternBuilder(val startDir: HexDir) {
    var angles = mutableListOf<HexAngle>()

    companion object {
        val northeast get() = HexPatternBuilder(HexDir.NORTH_WEST)
        val east get() = HexPatternBuilder(HexDir.NORTH_WEST)
        val southeast get() = HexPatternBuilder(HexDir.NORTH_WEST)
        val southwest get() = HexPatternBuilder(HexDir.NORTH_WEST)
        val west get() = HexPatternBuilder(HexDir.NORTH_WEST)
        val northwest get() = HexPatternBuilder(HexDir.NORTH_WEST)
    }

    val a get() = also { angles += HexAngle.LEFT_BACK }
    val q get() = also { angles += HexAngle.LEFT }
    val w get() = also { angles += HexAngle.FORWARD }
    val e get() = also { angles += HexAngle.RIGHT }
    val d get() = also { angles += HexAngle.RIGHT_BACK }
    val s get() = also { angles += HexAngle.BACK }

    operator fun invoke() = HexPattern(startDir, angles.toMutableList())
}

@Suppress("INAPPLICABLE_JVM_NAME")
interface RawIotaHolderItem: IotaHolderItem {
    var ItemStack.iotaTag: NbtCompound?
        @JvmName("readIotaTag") @Suppress("ACCIDENTAL_OVERRIDE") get
        @JvmName("hexmu\$writeIotaTag") set
}

fun copyFromBookself(
    shelf: BlockEntityAkashicBookshelf,
    world: World,
    pos: BlockPos,
    player: PlayerEntity,
    stack: ItemStack,
    cir: CallbackInfoReturnable<ActionResult>
) {
    val item = stack.item
    if (item is IotaHolderItem) {
        if (shelf.iotaTag == null || !item.writeable(stack)) {
            cir.returnValue = ActionResult.FAIL
            return
        }
        if (item is RawIotaHolderItem) {
            if (!world.isClient) {
                with(item) {
                    stack.iotaTag = shelf.iotaTag
                }
            }
            world.playSound(player, pos, HexSounds.SCROLL_SCRIBBLE, SoundCategory.BLOCKS, 1f, 1f);
            cir.returnValue = ActionResult.SUCCESS
            return
        }
        // we can only hunch
        if (world is ServerWorld) {
            val iota = IotaType.deserializeIota(shelf.iotaTag, world)
            if (item.canWrite(stack, iota)) {
                item.writeDatum(stack, iota);
                world.playSound(null, pos, HexSounds.SCROLL_SCRIBBLE, SoundCategory.BLOCKS, 1f, 1f);
            }
        }
        cir.returnValue = ActionResult.SUCCESS
    }
}
