package org.eu.net.pool.hexmu.mixin;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.storage.ItemThoughtKnot;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.eu.net.pool.hexmu.RawIotaHolderItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value = ItemThoughtKnot.class, remap = false)
public class ItemThoughtKnotMixin implements RawIotaHolderItem {
    @Shadow
    @Override
    public @Nullable class_2487 readIotaTag(@NotNull class_1799 itemStack) { return null; }

    @Shadow
    @Override
    public boolean writeable(class_1799 itemStack) { return false; }

    @Shadow
    @Override
    public boolean canWrite(class_1799 itemStack, @Nullable Iota iota) { return false; }

    @Shadow
    @Override
    public void writeDatum(class_1799 itemStack, @Nullable Iota iota) {}

    @Override
    public void hexmu$writeIotaTag(@NotNull class_1799 $this$iotaTag, @Nullable class_2487 nbtCompound) {
        if (nbtCompound != null) {
            NBTHelper.putCompound($this$iotaTag, "data", nbtCompound);
        }
    }
}
