package org.eu.net.pool.hexic.mixin;

import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import org.eu.net.pool.hexic.ducks.SimpleRegistryDuck;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;

import java.util.Map;
import net.minecraft.class_2370;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

@Mixin(class_2370.class)
public abstract class SimpleRegistryMixin<T> implements SimpleRegistryDuck {
    @Shadow @Final private ObjectList<class_6880.class_6883<T>> rawIdToEntry;
    @Shadow @Final private Object2IntMap<T> entryToRawId;
    @Shadow @Final private Map<class_2960, class_6880.class_6883<T>> idToEntry;
    @Shadow @Final private Map<class_5321<T>, class_6880.class_6883<T>> keyToEntry;
    @Shadow @Final private Map<T, class_6880.class_6883<T>> valueToEntry;
    @Shadow @Final private Map<T, Lifecycle> entryToLifecycle;
    @Shadow private boolean frozen;

    @Override
    public void hexic$clear() {
        rawIdToEntry.clear();
        entryToRawId.clear();
        idToEntry.clear();
        keyToEntry.clear();
        valueToEntry.clear();
        entryToLifecycle.clear();
    }

    @Override
    @Accessor
    public abstract void setFrozen(boolean frozen);
}
