package org.eu.net.pool.hexic.mixin;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.ExecutionClientView;
import at.petrak.hexcasting.api.casting.eval.ResolvedPatternType;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import kotlin.Pair;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.nbt.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;

import static net.minecraft.class_1802.field_38746;

@Mixin(value = CastingVM.class, remap = false)
public abstract class CastingVMMixin {
    @Shadow private @Final CastingEnvironment env;
    abstract @Shadow public Pair<List<class_2487>, @Nullable class_2487> generateDescs();

    @WrapMethod(method = "queueExecuteAndWrapIotas")
    ExecutionClientView hookForSculkShardStorage(List<? extends Iota> iotas, class_3218 world, Operation<ExecutionClientView> original) {
        if (env.getCastingEntity() instanceof class_3222 p) {
            class_1799 stack = p.method_5998(env.getOtherHand());
            if (stack.method_31574(field_38746)) {
                class_2487 tag = stack.method_7948();
                class_2499 queuedPatterns = tag.method_10554("hexic:memory", class_2520.field_33260);
                for (Iota i: iotas)
                    queuedPatterns.add(IotaType.serialize(i));
                tag.method_10566("hexic:memory", queuedPatterns);
                p.method_17356(class_3417.field_28081, class_3419.field_15248, 1.0f, 1.0f);
                var descs = generateDescs();
                return new ExecutionClientView(false, ResolvedPatternType.valueOf("HEXIC$ECHO_SHARD_ABSORBED"), descs.getFirst(), descs.getSecond());
            }
        }
        return original.call(iotas, world);
    }
}
