package org.eu.net.pool.common_curses.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import org.eu.net.pool.common_curses.HotbarRendering;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Objects;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;

@Mixin(class_329.class)
public class InGameHudMixin {
    @WrapOperation(method = "renderHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/InGameHud;renderHotbarItem(Lnet/minecraft/client/gui/DrawContext;IIFLnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;I)V", ordinal = 0))
    void filterHotbar(class_329 instance, class_332 context, int x, int y, float f, class_1657 player, class_1799 stack, int seed, Operation<Void> original, @Local(index = 10) int m, @Share("mode") LocalRef<HotbarRendering> modeRef) {
        switch (modeRef.get()) {
            case ALL -> original.call(instance, context, x, y, f, player, stack, seed);
            case SELECTED_SLOT -> {
                if (Objects.equals(m, player.method_31548().field_7545)) original.call(instance, context, x + 80 - player.method_31548().field_7545 * 20, y, f, player, stack, seed);
            }
        }
    }

    @WrapOperation(method = "renderHotbar", at = {
            @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/InGameHud;renderHotbarItem(Lnet/minecraft/client/gui/DrawContext;IIFLnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;I)V", ordinal = 1),
            @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/InGameHud;renderHotbarItem(Lnet/minecraft/client/gui/DrawContext;IIFLnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;I)V", ordinal = 2)
    })
    void shiftOffhand(class_329 instance, class_332 context, int x, int y, float f, class_1657 player, class_1799 stack, int seed, Operation<Void> original, @Share("mode") LocalRef<HotbarRendering> modeRef, @Local class_1306 arm) {
        switch (modeRef.get()) {
            case ALL -> original.call(instance, context, x, y, f, player, stack, seed);
            case SELECTED_SLOT -> original.call(instance, context, arm == class_1306.field_6182 ? x + 80 : x - 80, y, f, player, stack, seed);
        }
    }

    @WrapOperation(method = "renderHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V", ordinal = 0))
    void modifyHotbarRendering(class_332 instance, class_2960 texture, int x, int y, int u, int v, int width, int height, Operation<Void> original, @Local class_1657 player, @Share("mode") LocalRef<HotbarRendering> modeRef) {
        HotbarRendering mode = HotbarRendering.Companion.getEvent().invoker().invoke();
        modeRef.set(mode);
        switch (mode) {
            case ALL -> original.call(instance, texture, x, y, u, v, width, height);
            case SELECTED_SLOT -> original.call(instance, texture, x + 80, y, u, v, 20, height);
        }
    }

    @WrapOperation(method = "renderHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V", ordinal = 1))
    void modifyHotbarSelector(class_332 instance, class_2960 texture, int x, int y, int u, int v, int width, int height, Operation<Void> original, @Local class_1657 player, @Share("mode") LocalRef<HotbarRendering> modeRef) {
        switch (modeRef.get()) {
            case ALL -> original.call(instance, texture, x, y, u, v, width, height + 1);
            case SELECTED_SLOT -> original.call(instance, texture, x + 80 - player.method_31548().field_7545 * 20, y, u, v, width, height + 1);
        }
    }

    @WrapOperation(method = "renderHotbar", at = {
            @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V", ordinal = 2),
            @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V", ordinal = 3)
    })
    void shiftOffhand(class_332 instance, class_2960 texture, int x, int y, int u, int v, int width, int height, Operation<Void> original, @Share("mode") LocalRef<HotbarRendering> modeRef, @Local class_1306 arm) {
        switch (modeRef.get()) {
            case ALL -> original.call(instance, texture, x, y, u, v, width, height);
            case SELECTED_SLOT -> original.call(instance, texture, arm == class_1306.field_6182 ? x + 80 : x - 80, y, u, v, width, height);
        }
    }
}
