package org.eu.net.pool.common_curses.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import org.eu.net.pool.common_curses.SlotAccess;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

@Mixin(class_1661.class)
public abstract class PlayerInventoryMixin {
    private @Unique @Nullable class_1799 commonCurses$contextStack;

    @Shadow @Final public class_1657 player;
    @Shadow public abstract class_1799 getStack(int slot);

    @Unique
    private SlotAccess effectiveAccess(int slot, class_1799 stack) {
        return SlotAccess.playerInventory.invoker().invoke(player, slot, stack);
    }

    @Unique
    private SlotAccess effectiveAccess(int slot) {
        return effectiveAccess(slot, getStack(slot));
    }

    @WrapOperation(method = "getEmptySlot", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z"))
    boolean hideEmptyLockedSlots(class_1799 instance, Operation<Boolean> original, @Local int i) {
        return original.call(instance) && effectiveAccess(i, Objects.requireNonNullElse(commonCurses$contextStack, instance)).getCanInsert();
    }

    @WrapOperation(method = {
            "addPickBlock",
            "addStack(Lnet/minecraft/item/ItemStack;)I",
            "insertStack(ILnet/minecraft/item/ItemStack;)Z",
            "offer"
    }, at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;getEmptySlot()I"))
    int wrapGetEmptySlot(class_1661 instance, Operation<Integer> original, @Local(argsOnly = true) class_1799 stack) {
        try {
            this.commonCurses$contextStack = stack;
            return original.call(instance);
        } finally {
            this.commonCurses$contextStack = null;
        }
    }

    @WrapOperation(method = "getOccupiedSlotWithRoomForStack", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;getStack(I)Lnet/minecraft/item/ItemStack;"))
    class_1799 hidePartiallyFullSlots(class_1661 instance, int slot, Operation<class_1799> original) {
        var orig = original.call(instance, slot);
        return effectiveAccess(slot, orig).getCanInsert() ? orig : class_1799.field_8037;
    }
    @WrapOperation(method = "getOccupiedSlotWithRoomForStack", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/collection/DefaultedList;get(I)Ljava/lang/Object;"))
    Object hidePartiallyFullStacks(class_2371<class_1799> instance, int slot, Operation<class_1799> original) {
        var orig = original.call(instance, slot);
        return effectiveAccess(slot, orig).getCanInsert() ? orig : class_1799.field_8037;
    }

    @Inject(method = "removeStack(I)Lnet/minecraft/item/ItemStack;", at = @At("HEAD"), cancellable = true)
    void disallowRemoveLockedSlots(int slot, CallbackInfoReturnable<class_1799> cir) {
        if (!effectiveAccess(slot).getCanRemove()) {
            cir.setReturnValue(class_1799.field_8037);
        }
    }

    @Inject(method = "insertStack(ILnet/minecraft/item/ItemStack;)Z", at = @At("HEAD"), cancellable = true)
    void injectInsertStack(int slot, class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (slot != -1 && !effectiveAccess(slot, stack).getCanRemove()) {
            cir.setReturnValue(false);
        }
    }
}
