package org.eu.net.pool.common_curses.client

import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator
import net.minecraft.client.render.GameRenderer
import net.minecraft.client.sound.SoundInstance
import net.minecraft.entity.player.PlayerEntity
import net.minecraft.item.ItemStack
import org.eu.net.pool.common_curses.createEvent

@JvmField val playSoundEvent = createEvent<SoundInstance.() -> Boolean> { { all { it() } } }
@JvmField val useChatEvent = createEvent<() -> Boolean> { { all { it() } } }
@JvmField val postHUDEvent = createEvent<GameRenderer.(Float) -> Unit> { { delta -> forEach { it(delta) } } }

enum class HotbarRendering {
    NONE,
    SELECTED_SLOT,
    ALL;
    companion object {
        val event = createEvent<() -> HotbarRendering> { { map { it() }.minByOrNull(HotbarRendering::ordinal) ?: ALL } }
    }
}

fun clinit() {
    // TODO
}

fun datagen(gen: FabricDataGenerator) {
    { gen }() // TODO; shuts up LSP
}