package org.eu.net.pool.common_curses

import net.fabricmc.fabric.api.event.EventFactory
import net.minecraft.entity.player.PlayerEntity
import net.minecraft.item.ItemStack

inline fun <reified T: Any> createEvent(crossinline merge: Array<T>.() -> T) = EventFactory.createArrayBacked<T>(T::class.java) { it.merge() }!!

enum class SlotAccess(val canInsert: Boolean, val canRemove: Boolean, val dropItems: Boolean) {
    ALLOW(true, true, false),
    INSERT_ONLY(true, false, false),
    REMOVE_ONLY(false, true, false),
    LOCK(false, false, false),
    LOCK_AND_DROP(false, false, true);
    companion object {
        @JvmField val playerInventory = createEvent<(PlayerEntity, Int, ItemStack) -> SlotAccess> {
            { p, s, i ->
                val l = map { it(p, s, i) }.toSet()
                if (l.contains(LOCK_AND_DROP))
                    LOCK_AND_DROP
                else if (l.contains(LOCK) || l.containsAll(listOf(INSERT_ONLY, REMOVE_ONLY)))
                    LOCK
                else if (l.contains(INSERT_ONLY))
                    INSERT_ONLY
                else if (l.contains(REMOVE_ONLY))
                    REMOVE_ONLY
                else
                    ALLOW
            }
        }
    }
}

fun init() {

}