package org.eu.net.pool.common_curses.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_408;
import net.minecraft.class_4717;
import org.eu.net.pool.common_curses.client.CommonCursesClientKt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_408.class)
public class ChatScreenMixin {
    @Inject(method = "sendMessage", at = @At("HEAD"), cancellable = true)
    void preSendMessage(String chatText, boolean addToHistory, CallbackInfoReturnable<Boolean> cir) {
        if (!allowChat()) cir.cancel();
    }

    @Unique
    private boolean allowChat() {
        return CommonCursesClientKt.useChatEvent.invoker().invoke();
    }

    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V"))
    void fillProxy(class_332 instance, int x1, int y1, int x2, int y2, int color, Operation<Void> original) {
        if (allowChat()) original.call(instance, x1, y1, x2, y2, color);
    }

    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/widget/TextFieldWidget;render(Lnet/minecraft/client/gui/DrawContext;IIF)V"))
    void renderProxy(class_342 instance, class_332 drawContext, int i, int j, float v, Operation<Void> original) {
        if (allowChat()) original.call(instance, drawContext, i, j, v);
    }

    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ChatInputSuggestor;render(Lnet/minecraft/client/gui/DrawContext;II)V"))
    void renderProxy(class_4717 instance, class_332 context, int mouseX, int mouseY, Operation<Void> original) {
        if (allowChat()) original.call(instance, context, mouseX, mouseY);
    }
}
