package org.eu.net.pool.common_curses.mixin;

import com.mojang.authlib.GameProfile;
import org.eu.net.pool.common_curses.SlotAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends class_1657 {
    // removed by Mixin
    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(at = @At("HEAD"), method = "tick")
    void dropItemsForDropping(CallbackInfo ci) {
        class_1661 inventory = this.method_31548();
        List<class_1799> removedItems = new ArrayList<>();
        var invoker = SlotAccess.playerInventory.invoker();
        try {
            for (int i = 0; i < inventory.method_5439(); i++) {
                if (invoker.invoke(this, i, inventory.method_5438(i)).getDropItems()) {
                    removedItems.add(inventory.method_5438(i));
                    inventory.method_5447(i, class_1799.field_8037);
                }
            }
        } finally {
            for (class_1799 stack: removedItems) {
                inventory.method_7398(stack);
            }
        }
    }
}
