package org.eu.net.pool.common_curses.client

import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator
import net.minecraft.client.render.GameRenderer
import net.minecraft.client.sound.SoundInstance
import net.minecraft.entity.player.PlayerEntity
import net.minecraft.item.ItemStack
import org.eu.net.pool.common_curses.TextManipulator
import org.eu.net.pool.common_curses.createEvent

/**
 * Fired when a sound is played client-side. An event may mutate the [SoundInstance] or return `false` to cancel the sound. All listeners must return `true` for the sound to be audible.
 */
@JvmField val playSoundEvent = createEvent<SoundInstance.() -> Boolean> { { all { it() } } }

/**
 * Fired every frame the player is trying to send a message. For messaging to be available, all listeners must return `true`.
 * @see net.minecraft.client.MinecraftClient.player
 */
@JvmField val useChatEvent = createEvent<() -> Boolean> { { all { it() } } }

/**
 * Fired every frame, above the HUD. Mods may render their overlays here.
 */
@JvmField val postHUDEvent = createEvent<GameRenderer.(Float) -> Unit> { { delta -> forEach { it(delta) } } }

/**
 * Fired to modify a chat message received by the player. This event should return a [TextManipulator]; the highest-[priority][TextManipulator.priority] one will be used. Ties are resolved in an undefined order. To leave chat unmodified, use [TextManipulator.None].
 */
@JvmField val modifyChatEvent = createEvent<() -> TextManipulator> { { map { it() }.maxByOrNull(TextManipulator::priority) ?: TextManipulator.None } }

/**
 * Fired to modify a rendered string of text. This follows the same logic as [modifyChatEvent].
 */
@JvmField val modifyTextRenderingEvent = createEvent<() -> TextManipulator> { { map { it() }.maxByOrNull(TextManipulator::priority) ?: TextManipulator.None } }

/**
 * Fired to control hotbar slots' visibility. The most severe rendering change (the one with the highest [ordinal][HotbarRendering.ordinal]) is used.
 */
enum class HotbarRendering {
    /**
     * The player's entire hotbar is hidden. Mods using this should ensure that the offhand is inaccessible, as the behavior of offhand items in this mode is undefined.
     */
    NONE,

    /**
     * Only the player's [selectedSlot][net.minecraft.entity.player.PlayerInventory.selectedSlot] is visible. Mods using this should ensure that if they want to only render one slot, the selected slot is locked in some way. Common Curses currently provides no selected-slot-locking behavior.
     */
    SELECTED_SLOT,

    /**
     * Follow vanilla hotbar rendering behavior. All slots are visible.
     */
    ALL;
    companion object {
        val event = createEvent<() -> HotbarRendering> { { map { it() }.minByOrNull(HotbarRendering::ordinal) ?: ALL } }
    }
}

fun clinit() {
    // TODO
}

fun datagen(gen: FabricDataGenerator) {
    { gen }() // TODO; shuts up LSP
}