package org.eu.net.pool.common_curses.mixin.client;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.eu.net.pool.common_curses.SlotAccess;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_1735.class)
public abstract class SlotMixin {
    @Shadow @Final public class_1263 inventory;
    @Shadow @Final private int index;
    @Shadow public abstract class_1799 getStack();

    @Unique
    private SlotAccess access() {
        return inventory instanceof class_1661 pi ? SlotAccess.playerInventory.invoker().invoke(pi.field_7546, index, getStack()) : /* TODO: consider an event for this */ SlotAccess.ALLOW;
    }

    @WrapMethod(method = "isEnabled")
    boolean isEnabled(Operation<Boolean> orig) {
        return access() != SlotAccess.LOCK_AND_DROP && orig.call();
    }

    @WrapMethod(method = "canInsert")
    boolean canInsert(class_1799 stack, Operation<Boolean> orig) {
        return access().getCanInsert() && orig.call(stack);
    }

    @WrapMethod(method = {"canTakeItems", "canTakePartial"})
    boolean canTakeItems(class_1657 player, Operation<Boolean> orig) {
        return access().getCanRemove() && orig.call(player);
    }
}
