package miyucomics.hexical.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import miyucomics.hexical.features.periwinkle.SnifferEntityMinterface;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_52;
import net.minecraft.class_8153;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_8153.class)
@SuppressWarnings("AddedMixinMembersNamePattern")
public abstract class SnifferEntityMixin implements SnifferEntityMinterface {
	@Shadow public abstract class_8153 startState(class_8153.class_8154 state);
	@Shadow public abstract class_4095<class_8153> getBrain();
	@Unique private class_1799 customItem = null;
	@Unique private boolean isDiggingCustom = false;

	@Override
	public boolean isDiggingCustom() {
		return isDiggingCustom;
	}

	@Override
	public void produceItem(@NotNull class_1799 stack) {
		this.customItem = stack;
		this.isDiggingCustom = true;
		getBrain().method_18875(class_4140.field_38105);
		getBrain().method_18875(class_4140.field_38103);
		getBrain().method_18875(class_4140.field_18445);
		getBrain().method_18875(class_4140.field_42638);
		getBrain().method_18875(class_4140.field_19293);

		getBrain().method_18878(class_4140.field_42639, true);

		getBrain().method_18900((class_3218) ((class_8153) (Object) this).method_37908(), ((class_8153) (Object) this));
		getBrain().method_24536();
		startState(class_8153.class_8154.field_42670);
	}

	@Inject(method = "canTryToDig", at = @At("HEAD"), cancellable = true)
	public void youWantToDig(CallbackInfoReturnable<Boolean> cir) {
		if (isDiggingCustom)
			cir.setReturnValue(true);
	}

	@Inject(method = "canDig", at = @At("HEAD"), cancellable = true)
	public void youCanDig(CallbackInfoReturnable<Boolean> cir) {
		if (isDiggingCustom)
			cir.setReturnValue(true);
	}

	@WrapOperation(method = "dropSeeds", at = @At(value = "INVOKE", target = "Lnet/minecraft/loot/LootTable;generateLoot(Lnet/minecraft/loot/context/LootContextParameterSet;)Lit/unimi/dsi/fastutil/objects/ObjectArrayList;"))
	public ObjectArrayList<class_1799> alterDrops(class_52 instance, class_8567 lootContextParameterSet, Operation<ObjectArrayList<class_1799>> original) {
		if (isDiggingCustom) {
			ObjectArrayList<class_1799> newDrops = new ObjectArrayList<>();
			newDrops.add(customItem);
			customItem = null;
			isDiggingCustom = false;
			return newDrops;
		}
		return original.call(instance, lootContextParameterSet);
	}
}