package miyucomics.hexical.mixin;

import at.petrak.hexcasting.client.gui.GuiSpellcasting;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import miyucomics.hexical.inits.HexicalBlocks;
import net.minecraft.class_1320;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value = GuiSpellcasting.class)
public class GuiSpellcastingMixin {
	@Unique
	long lastCounter = System.currentTimeMillis();
	@Unique
	double zoomFactor = 0;

	@WrapOperation(method = "hexSize", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/network/ClientPlayerEntity;getAttributeValue(Lnet/minecraft/entity/attribute/EntityAttribute;)D"))
	double thinkyCarpet(class_746 player, class_1320 entityAttribute, Operation<Double> original) {
		long deltaTime = System.currentTimeMillis() - lastCounter;
		lastCounter = System.currentTimeMillis();

		if (player.method_36601().method_27852(HexicalBlocks.CASTING_CARPET)) {
			zoomFactor += (double) deltaTime / 500;
		} else {
			zoomFactor -= (double) deltaTime / 500;
		}
		zoomFactor = class_3532.method_15350(zoomFactor, 0, 0.35);

		double returnValue = original.call(player, entityAttribute);
		returnValue += zoomFactor;
		return returnValue;
	}
}