package miyucomics.hexical.mixin;

import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.PlayerBasedCastEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import miyucomics.hexical.features.media_log.MediaLogField;
import miyucomics.hexical.features.media_log.MediaLogFieldKt;
import miyucomics.hexical.features.periwinkle.WooleyedEffect;
import miyucomics.hexical.inits.HexicalItems;
import net.minecraft.class_1304;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value = PlayerBasedCastEnv.class, remap = false)
public class PlayerBasedCastEnvMixin {
	@Shadow @Final protected class_3222 caster;

	@Inject(method = "canOvercast", at = @At("HEAD"), cancellable = true)
	private void canOvercast(CallbackInfoReturnable<Boolean> cir) {
		if (this.caster.method_6118(class_1304.field_6169).method_31574(HexicalItems.LEI) || this.caster.method_6059(WooleyedEffect.INSTANCE))
			cir.setReturnValue(false);
	}

	@Inject(method = "sendMishapMsgToPlayer(Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$DoMishap;)V", at = @At("HEAD"))
	private void captureMishap(OperatorSideEffect.DoMishap mishap, CallbackInfo ci) {
		class_2561 message = mishap.getMishap().errorMessageWithName((CastingEnvironment) (Object) this, mishap.getErrorCtx());
		if (message != null && MediaLogField.isEnvCompatible((CastingEnvironment) (Object) this))
			MediaLogFieldKt.getMediaLog(caster).saveMishap(message);
	}
}