package miyucomics.hexical.mixin;

import at.petrak.hexcasting.common.lib.HexSounds;
import kotlin.Pair;
import miyucomics.hexical.features.charms.CharmUtilities;
import miyucomics.hexical.features.charms.ServerCharmedUseReceiver;
import miyucomics.hexical.features.curios.CurioItem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_3419;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_312.class)
public class MouseMixin {
	@Shadow @Final private class_310 client;

	@Inject(method = "onMouseButton", at = @At("HEAD"), cancellable = true)
	private void onMouseButton(long window, int button, int action, int mods, CallbackInfo ci) {
		if (client.field_1755 != null || client.method_18506() != null) return;
		if (client.field_1724 == null || client.field_1724.method_7325()) return;
		if (action != GLFW.GLFW_PRESS) return;

		int buttonPressed = switch (button) {
			case GLFW.GLFW_MOUSE_BUTTON_1 -> 0; // left
			case GLFW.GLFW_MOUSE_BUTTON_2 -> 1; // right
			case GLFW.GLFW_MOUSE_BUTTON_3 -> 2; // middle
			case GLFW.GLFW_MOUSE_BUTTON_4 -> 3;
			case GLFW.GLFW_MOUSE_BUTTON_5 -> 4;
			case GLFW.GLFW_MOUSE_BUTTON_6 -> 5;
			case GLFW.GLFW_MOUSE_BUTTON_7 -> 6;
			case GLFW.GLFW_MOUSE_BUTTON_8 -> 7;
			default -> -1;
		};

		if (buttonPressed == -1)
			return;

		for (Pair<class_1268, class_1799> pair : CharmUtilities.getUseableCharmedItems(client.field_1724)) {
			if (!CharmUtilities.shouldIntercept(pair.getSecond(), buttonPressed, client.field_1724.method_5715()))
				continue;

			if (!(pair.getSecond().method_7909() instanceof CurioItem)) {
				client.field_1724.method_6104(pair.getFirst());
				client.field_1724.field_17892.method_43128(null, client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321(), HexSounds.CAST_HERMES, class_3419.field_15250, 0.25f, 1f);
			}

			class_2540 buf = PacketByteBufs.create();
			buf.writeInt(buttonPressed);
			buf.writeInt(pair.getFirst().ordinal());
			ClientPlayNetworking.send(ServerCharmedUseReceiver.CHARMED_ITEM_USE_CHANNEL, buf);
			ci.cancel();
			return;
		}
	}
}