package miyucomics.hexical.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import miyucomics.hexical.features.wristpocket.WristpocketFieldKt;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_6024;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin {
	@Shadow public abstract void setHealth(float health);
	@Shadow public abstract boolean clearStatusEffects();
	@Shadow public abstract boolean addStatusEffect(class_1293 effect);

	@WrapOperation(method = "damage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;tryUseTotem(Lnet/minecraft/entity/damage/DamageSource;)Z"))
	private boolean undie(class_1309 instance, class_1282 source, Operation<Boolean> original) {
		if (!(instance instanceof class_3222 player))
			return original.call(instance, source);

		class_1799 wristpocket = WristpocketFieldKt.getWristpocket(player);
		if (wristpocket.method_31574(class_1802.field_8288)) {
			WristpocketFieldKt.setWristpocket(player, class_1799.field_8037);
			player.method_7259(class_3468.field_15372.method_14956(class_1802.field_8288));
			class_174.field_1204.method_9165(player, wristpocket);

			setHealth(1.0f);
			clearStatusEffects();
			addStatusEffect(new class_1293(class_1294.field_5924, 900, 1));
			addStatusEffect(new class_1293(class_1294.field_5898, 100, 1));
			addStatusEffect(new class_1293(class_1294.field_5918, 800, 0));
			player.method_37908().method_8421((class_1297) (Object) this, class_6024.field_30003);

			return true;
		}

		return original.call(instance, source);
	}
}