package miyucomics.hexical.mixin;

import miyucomics.hexical.features.player.PlayerEntityMinterface;
import miyucomics.hexical.features.player.PlayerManager;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
@SuppressWarnings("AddedMixinMembersNamePattern")
public class PlayerEntityMixin implements PlayerEntityMinterface {
	@Unique
	private final PlayerManager hexicalPlayerManager = new PlayerManager();

	@Inject(method = "tick", at = @At("TAIL"))
	void tick(CallbackInfo ci) {
		hexicalPlayerManager.tick((class_1657) (Object) this);
	}

	@Inject(method = "readCustomDataFromNbt", at = @At("HEAD"))
	void reaadPlayerData(class_2487 compound, CallbackInfo ci) {
		hexicalPlayerManager.readNbt(compound);
	}

	@Inject(method = "writeCustomDataToNbt", at = @At("HEAD"))
	void writePlayerData(class_2487 compound, CallbackInfo ci) {
		hexicalPlayerManager.writeNbt(compound);
	}

	@Override
	public @NotNull PlayerManager getPlayerManager() {
		return hexicalPlayerManager;
	}
}