package miyucomics.hexical.mixin;

import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import miyucomics.hexical.features.pedestal.PedestalBlockEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

@Mixin(value = CircleCastEnv.class, remap = false)
public abstract class CircleCastEnvMixin {
	@Shadow public abstract CircleExecutionState circleState();

	@WrapMethod(method = "getPrimaryStacks")
	public List<CastingEnvironment.HeldItemInfo> addHands(Operation<List<CastingEnvironment.HeldItemInfo>> original) {
		List<CastingEnvironment.HeldItemInfo> initial = new ArrayList<>(original.call());
		if (circleState().currentImage.getUserData().method_10545("impetus_hand")) {
			PedestalBlockEntity pedestal = getPedestal();
			initial.add(new CastingEnvironment.HeldItemInfo(pedestal.getStack(0), class_1268.field_5810));
		}
		return initial;
	}

	@Inject(method = "replaceItem", at = @At("HEAD"), cancellable = true)
	public void addHands(Predicate<class_1799> stackOk, class_1799 replaceWith, @Nullable class_1268 hand, CallbackInfoReturnable<Boolean> cir) {
		if (circleState().currentImage.getUserData().method_10545("impetus_hand")) {
			PedestalBlockEntity pedestal = getPedestal();
			class_1799 heldStack = pedestal.getStack(0);
			if (stackOk.test(heldStack)) {
				pedestal.setStack(0, replaceWith);
				cir.setReturnValue(true);
			}
		}
	}

	@Unique
	private PedestalBlockEntity getPedestal() {
		int[] position = circleState().currentImage.getUserData().method_10561("impetus_hand");
		class_3218 world = ((CastingEnvironment) (Object) this).getWorld();
		PedestalBlockEntity pedestal = (PedestalBlockEntity) world.method_8321(new class_2338(position[0], position[1], position[2]));
		assert pedestal != null;
		return pedestal;
	}
}