package miyucomics.hexical.features.flora

import at.petrak.hexcasting.api.casting.ParticleSpray
import at.petrak.hexcasting.api.casting.RenderedSpell
import at.petrak.hexcasting.api.casting.castables.SpellAction
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment
import at.petrak.hexcasting.api.casting.getBlockPos
import at.petrak.hexcasting.api.casting.iota.Iota
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota
import miyucomics.hexpose.iotas.getIdentifier
import net.minecraft.block.Block
import net.minecraft.block.BlockState
import net.minecraft.block.FlowerPotBlock
import net.minecraft.block.TallPlantBlock
import net.minecraft.registry.Registries
import net.minecraft.registry.tag.BlockTags
import net.minecraft.util.math.BlockPos
import net.minecraft.util.math.Direction
import net.minecraft.util.math.Vec3d

object OpConjureFlora : SpellAction {
	override val argc = 2
	override fun execute(args: List<Iota>, env: CastingEnvironment): SpellAction.Result {
		val position = args.getBlockPos(0, argc)
		env.assertPosInRange(position)

		val id = args.getIdentifier(1, argc)
		if (!Registries.BLOCK.containsId(id))
			throw MishapInvalidIota.of(args[1], 0, "conjurable_flora_id")

		val recipe = ConjureFloraHook.getRecipe(env.world, Registries.BLOCK.get(id)) ?: throw MishapInvalidIota.of(args[1], 0, "conjurable_flora_id")

		if (env.world.getBlockState(position).isIn(BlockTags.FLOWER_POTS) && FlowerPotBlock.CONTENT_TO_POTTED.contains(recipe.state.block))
			return SpellAction.Result(PotPlant(position, recipe.state), recipe.cost, listOf(ParticleSpray.cloud(Vec3d.ofCenter(position), 1.0)))

		if (!env.world.getBlockState(position).isReplaceable)
			throw MishapBadBlock.of(position, "flower_spawnable")
		if (recipe.state.properties.contains(TallPlantBlock.HALF) && !env.world.getBlockState(position.up()).isReplaceable)
			throw MishapBadBlock.of(position.up(), "flower_spawnable")
		if (!env.world.getBlockState(position.down()).isSideSolidFullSquare(env.world, position.down(), Direction.UP))
			throw MishapBadBlock.of(position.down(), "solid_platform")

		return SpellAction.Result(GroundPlant(position, recipe.state), recipe.cost, listOf(ParticleSpray.cloud(Vec3d.ofCenter(position), 1.0)))
	}

	private data class GroundPlant(val position: BlockPos, val flower: BlockState) : RenderedSpell {
		override fun cast(env: CastingEnvironment) {
			if (flower.block is TallPlantBlock) {
				TallPlantBlock.placeAt(env.world, flower, position, Block.NOTIFY_LISTENERS or Block.FORCE_STATE)
			} else {
				env.world.setBlockState(position, flower)
			}
		}
	}

	private data class PotPlant(val position: BlockPos, val flower: BlockState) : RenderedSpell {
		override fun cast(env: CastingEnvironment) {
			env.world.setBlockState(position, FlowerPotBlock.CONTENT_TO_POTTED[flower.block]!!.defaultState)
		}
	}
}