/*
 * Decompiled with CFR 0.152.
 */
package miyucomics.hexical.features.hopper;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.sideeffects.EvalSound;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.casting.mishaps.MishapNotEnoughArgs;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import miyucomics.hexical.features.hopper.HopperDestination;
import miyucomics.hexical.features.hopper.HopperEndpoint;
import miyucomics.hexical.features.hopper.HopperEndpointRegistry;
import miyucomics.hexical.features.hopper.HopperSource;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lmiyucomics/hexical/features/hopper/OpHopper;", "Lat/petrak/hexcasting/api/casting/castables/Action;", "<init>", "()V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/eval/vm/CastingImage;", "image", "Lat/petrak/hexcasting/api/casting/eval/vm/SpellContinuation;", "continuation", "Lat/petrak/hexcasting/api/casting/eval/OperationResult;", "operate", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;Lat/petrak/hexcasting/api/casting/eval/vm/CastingImage;Lat/petrak/hexcasting/api/casting/eval/vm/SpellContinuation;)Lat/petrak/hexcasting/api/casting/eval/OperationResult;", "Spell", "hexical"})
public final class OpHopper
implements Action {
    @NotNull
    public static final OpHopper INSTANCE = new OpHopper();

    private OpHopper() {
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        List stack = CollectionsKt.toMutableList((Collection)image.getStack());
        int inputsConsumed = 0;
        Integer inputSlot = null;
        Integer outputSlot = null;
        if (!((Collection)stack).isEmpty() && CollectionsKt.last((List)stack) instanceof DoubleIota) {
            Object e = stack.remove(CollectionsKt.getLastIndex((List)stack));
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type at.petrak.hexcasting.api.casting.iota.DoubleIota");
            outputSlot = (int)((DoubleIota)e).getDouble();
            ++inputsConsumed;
        }
        if (stack.isEmpty()) {
            throw new MishapNotEnoughArgs(2, 1);
        }
        Iota destinationIota = (Iota)stack.remove(CollectionsKt.getLastIndex((List)stack));
        HopperEndpoint hopperEndpoint = HopperEndpointRegistry.INSTANCE.resolve(destinationIota, env, outputSlot);
        HopperDestination hopperDestination = hopperEndpoint instanceof HopperDestination ? (HopperDestination)hopperEndpoint : null;
        if (hopperDestination == null) {
            throw MishapInvalidIota.Companion.of(destinationIota, inputsConsumed, "hopper_destination", new Object[0]);
        }
        HopperDestination destination = hopperDestination;
        ++inputsConsumed;
        if (!((Collection)stack).isEmpty() && CollectionsKt.last((List)stack) instanceof DoubleIota) {
            Object e = stack.remove(CollectionsKt.getLastIndex((List)stack));
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type at.petrak.hexcasting.api.casting.iota.DoubleIota");
            inputSlot = (int)((DoubleIota)e).getDouble();
            ++inputsConsumed;
        }
        if (stack.isEmpty()) {
            throw new MishapNotEnoughArgs(inputsConsumed + 1, inputsConsumed);
        }
        Iota sourceIota = (Iota)stack.remove(CollectionsKt.getLastIndex((List)stack));
        HopperEndpoint hopperEndpoint2 = HopperEndpointRegistry.INSTANCE.resolve(sourceIota, env, inputSlot);
        HopperSource hopperSource = hopperEndpoint2 instanceof HopperSource ? (HopperSource)hopperEndpoint2 : null;
        if (hopperSource == null) {
            throw MishapInvalidIota.Companion.of(sourceIota, inputsConsumed, "hopper_source", new Object[0]);
        }
        HopperSource source = hopperSource;
        Map<class_1799, Integer> itemsToMove = destination.simulateDeposits(source.getItems());
        int totalItems = CollectionsKt.sumOfInt((Iterable)itemsToMove.values());
        CastingImage castingImage = CastingImage.copy$default((CastingImage)image.withUsedOp(), (List)stack, (int)0, null, (boolean)false, (long)0L, null, (int)62, null);
        Object[] objectArray = new OperatorSideEffect[]{(OperatorSideEffect)new OperatorSideEffect.ConsumeMedia((long)totalItems * 10000L * (long)3 / (long)64), (OperatorSideEffect)new OperatorSideEffect.AttemptSpell((RenderedSpell)new Spell(source, destination, itemsToMove), true, true)};
        List list = CollectionsKt.listOf((Object[])objectArray);
        EvalSound evalSound = HexEvalSounds.SPELL;
        Intrinsics.checkNotNullExpressionValue((Object)evalSound, (String)"SPELL");
        return new OperationResult(castingImage, list, continuation, evalSound);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J:\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010!\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010\u0014R#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010%\u001a\u0004\b&\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010\u0012\u00a8\u0006)"}, d2={"Lmiyucomics/hexical/features/hopper/OpHopper$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "Lmiyucomics/hexical/features/hopper/HopperSource;", "source", "Lmiyucomics/hexical/features/hopper/HopperDestination;", "destination", "", "Lnet/minecraft/class_1799;", "", "itemsToMove", "<init>", "(Lmiyucomics/hexical/features/hopper/HopperSource;Lmiyucomics/hexical/features/hopper/HopperDestination;Ljava/util/Map;)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "", "cast", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)V", "component1", "()Lmiyucomics/hexical/features/hopper/HopperSource;", "component2", "()Lmiyucomics/hexical/features/hopper/HopperDestination;", "component3", "()Ljava/util/Map;", "copy", "(Lmiyucomics/hexical/features/hopper/HopperSource;Lmiyucomics/hexical/features/hopper/HopperDestination;Ljava/util/Map;)Lmiyucomics/hexical/features/hopper/OpHopper$Spell;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lmiyucomics/hexical/features/hopper/HopperDestination;", "getDestination", "Ljava/util/Map;", "getItemsToMove", "Lmiyucomics/hexical/features/hopper/HopperSource;", "getSource", "hexical"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final HopperSource source;
        @NotNull
        private final HopperDestination destination;
        @NotNull
        private final Map<class_1799, Integer> itemsToMove;

        public Spell(@NotNull HopperSource source, @NotNull HopperDestination destination, @NotNull Map<class_1799, Integer> itemsToMove) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Intrinsics.checkNotNullParameter(itemsToMove, (String)"itemsToMove");
            this.source = source;
            this.destination = destination;
            this.itemsToMove = itemsToMove;
        }

        @NotNull
        public final HopperSource getSource() {
            return this.source;
        }

        @NotNull
        public final HopperDestination getDestination() {
            return this.destination;
        }

        @NotNull
        public final Map<class_1799, Integer> getItemsToMove() {
            return this.itemsToMove;
        }

        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            for (Map.Entry<class_1799, Integer> entry : this.itemsToMove.entrySet()) {
                boolean didWithdraw = this.source.withdraw(entry.getKey(), ((Number)entry.getValue()).intValue());
                if (!didWithdraw) continue;
                int n = entry.getKey().method_7947();
                class_1799 class_17992 = entry.getKey().method_7972();
                Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"entry.key.copy()");
                int added = n - this.destination.deposit(class_17992).method_7947();
                if (added > ((Number)entry.getValue()).intValue()) {
                    HexAPI.LOGGER.warn("OpHopper somehow added more items (" + added + ") than expected (" + entry.getValue() + ")");
                }
                if (added >= ((Number)entry.getValue()).intValue()) continue;
                HexAPI.LOGGER.warn("OpHopper somehow added fewer items (" + added + ") than expected (" + entry.getValue() + ")");
            }
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        @NotNull
        public final HopperSource component1() {
            return this.source;
        }

        @NotNull
        public final HopperDestination component2() {
            return this.destination;
        }

        @NotNull
        public final Map<class_1799, Integer> component3() {
            return this.itemsToMove;
        }

        @NotNull
        public final Spell copy(@NotNull HopperSource source, @NotNull HopperDestination destination, @NotNull Map<class_1799, Integer> itemsToMove) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            Intrinsics.checkNotNullParameter(itemsToMove, (String)"itemsToMove");
            return new Spell(source, destination, itemsToMove);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, HopperSource hopperSource, HopperDestination hopperDestination, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                hopperSource = spell.source;
            }
            if ((n & 2) != 0) {
                hopperDestination = spell.destination;
            }
            if ((n & 4) != 0) {
                map = spell.itemsToMove;
            }
            return spell.copy(hopperSource, hopperDestination, map);
        }

        @NotNull
        public String toString() {
            return "Spell(source=" + this.source + ", destination=" + this.destination + ", itemsToMove=" + this.itemsToMove + ")";
        }

        public int hashCode() {
            int result2 = this.source.hashCode();
            result2 = result2 * 31 + this.destination.hashCode();
            result2 = result2 * 31 + ((Object)this.itemsToMove).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.source, (Object)spell.source)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.destination, (Object)spell.destination)) {
                return false;
            }
            return Intrinsics.areEqual(this.itemsToMove, spell.itemsToMove);
        }
    }
}

