package io.github.tropheusj.serialization_hooks.value;

import net.minecraft.class_1856.class_1859;

/**
 * A custom Value. Should be implemented onto all custom Values.
 */
public interface CustomValue {
	/**
	 * @return the custom ValueDeserializer used by this value, or null
	 * if vanilla deserialization should be used.
	 */
	ValueDeserializer getDeserializer();

	default boolean customDeserializer() {
		return getDeserializer() != null;
	}

	static boolean customDeserializer(class_1859 value) {
		return value instanceof CustomValue c && c.customDeserializer();
	}
}
