package io.github.tropheusj.serialization_hooks.value;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import io.github.tropheusj.serialization_hooks.SerializationHooks;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.minecraft.class_1856;
import net.minecraft.class_1856.class_1859;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

/**
 * A ValueDeserializer handles converting Json back to a Value.
 */
public interface ValueDeserializer {
	/**
	 * The Registry for serializers.
	 */
	class_2378<ValueDeserializer> REGISTRY = FabricRegistryBuilder.createSimple(
			ValueDeserializer.class, SerializationHooks.id("value_deserializers")
	).attribute(RegistryAttribute.SYNCED).buildAndRegister();

	/**
	 * Create a Value from the given json object.
	 * This should reflect the corresponding {@link class_1859#method_8109()} method in your Value.
	 */
	class_1856.class_1859 fromJson(JsonObject object);

	static void init() {
		// load the class and registry
	}

	/**
	 * Try to deserialize a Value from the given JsonObject.
	 * @return the deserialized value, or null if not custom
	 */
	@Nullable
	static class_1859 tryDeserializeJson(JsonObject object) {
		JsonElement type = object.get("value_deserializer");
		if (type != null && type.isJsonPrimitive()) {
			class_2960 deserializerId = new class_2960(type.getAsString());
			ValueDeserializer deserializer = ValueDeserializer.REGISTRY.method_10223(deserializerId);
			if (deserializer == null)
				throw new IllegalStateException("Value deserializer with ID not found: " + deserializerId);
			return deserializer.fromJson(object);
		}
		return null;
	}
}
