package dev.kineticcat.hexportation.fabric.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import kotlin.Pair;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

import java.util.List;
import java.util.Objects;

public class ConduitIota extends Iota {

    public record Conduit(class_2338 source, class_2350 sourceDir, class_2338 sink, class_2350 sinkDir) {
        private static final String SOURCE_TAG = "Source";
        private static final String SOURCE_DIR_TAG = "SourceDir";
        private static final String SINK_TAG = "Sink";
        private static final String SINK_DIR_TAG = "SinkDir";
        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Conduit conduit = (Conduit) o;
            return Objects.equals(source, conduit.source)
                    && sourceDir == conduit.sourceDir
                    && Objects.equals(sink, conduit.sink)
                    && sinkDir == conduit.sinkDir;
        }
        private static class_2487 serialisePos(class_2338 pos) {
            class_2487 ctag = new class_2487();
            ctag.method_10569("X", pos.method_10263());
            ctag.method_10569("Y", pos.method_10264());
            ctag.method_10569("Z", pos.method_10260());
            return ctag;
        }
        public class_2487 serialise() {
            class_2487 ctag = new class_2487();
            ctag.method_10566(SOURCE_TAG, serialisePos(source));
            ctag.method_10582(SOURCE_DIR_TAG, sourceDir.method_15434());
            ctag.method_10566(SINK_TAG, serialisePos(sink));
            ctag.method_10582(SINK_DIR_TAG, sinkDir.method_15434());
            return ctag;
        }
        private static class_2338 deserialisePos(class_2487 ctag) {
            return new class_2338(
                    ctag.method_10550("X"),
                    ctag.method_10550("Y"),
                    ctag.method_10550("Z")
            );
        }
        public Conduit(class_2487 ctag) {
            this(
                    deserialisePos((class_2487) ctag.method_10580(SOURCE_TAG)),
                    class_2350.method_10168(ctag.method_10558(SOURCE_DIR_TAG)),
                    deserialisePos((class_2487) ctag.method_10580(SINK_TAG)),
                    class_2350.method_10168(ctag.method_10558(SINK_DIR_TAG))
            );
        }
        public ConduitIota asIota() { return new ConduitIota(this); }

        public Pair<Storage<ItemVariant>, Storage<ItemVariant>> getItemStoragesOrNull(class_3218 sLevel) {
            Storage<ItemVariant> sourceStorage = ItemStorage.SIDED.find(sLevel, source, sourceDir);
            Storage<ItemVariant> sinkStorage = ItemStorage.SIDED.find(sLevel, sink, sinkDir);
            return new Pair<>(sourceStorage, sinkStorage);
        }
        public Pair<Storage<FluidVariant>, Storage<FluidVariant>> getFluidStoragesOrNull(class_3218 sLevel) {
            Storage<FluidVariant> sourceStorage = FluidStorage.SIDED.find(sLevel, source, sourceDir);
            Storage<FluidVariant> sinkStorage = FluidStorage.SIDED.find(sLevel, sink, sinkDir);
            return new Pair<>(sourceStorage, sinkStorage);
        }
        public Pair<EnergyStorage, EnergyStorage> getEnergyStoragesOrNull(class_3218 sLevel) {
            EnergyStorage sourceStorage = EnergyStorage.SIDED.find(sLevel, source, sourceDir);
            EnergyStorage sinkStorage = EnergyStorage.SIDED.find(sLevel, sink, sinkDir);
            if (sourceStorage != null && sinkStorage != null) return new Pair<>(sourceStorage, sinkStorage);
            else return null;
        }

    }

    public ConduitIota(class_2338 source, class_2350 sourceDir, class_2338 sink, class_2350 sinkDir) {
        super(HexportationIotaTypes.CONDUIT, new Conduit(source, sourceDir, sink, sinkDir));
    }
    public ConduitIota(Conduit conduit) {
        super(HexportationIotaTypes.CONDUIT, conduit);
    }
    public Conduit getConduit() {
        return (Conduit) payload;
    }
    @Override
    public boolean isTruthy() {
        return true;
    }

    @Override
    protected boolean toleratesOther(Iota that) {
        return typesMatch(this, that)
                && that instanceof ConduitIota iota
                && tolerates(getConduit(), iota.getConduit());
    }

    public static boolean tolerates(Conduit A, Conduit B) {
        return A.equals(B);
    }

    @Override
    public @NotNull class_2520 serialize() {
        return getConduit().serialise();
    }
    public static IotaType<ConduitIota> TYPE = new IotaType<ConduitIota>() {
        @Override
        public ConduitIota deserialize(class_2520 tag, class_3218 world) throws IllegalArgumentException {
            return ConduitIota.deserialize(tag);
        }

        @Override
        public class_2561 display(class_2520 tag) {
            return ConduitIota.display(ConduitIota.deserialize(tag).getConduit());
        }

        @Override
        public int color() {
            return 16755200;
        }
    };

    public static ConduitIota deserialize(class_2520 tag) {
        class_2487 ctag = HexUtils.downcast(tag, class_2487.field_21029);
        return new Conduit((class_2487) tag).asIota();
    }

    public static class_2561 display(Conduit conduit) {
        return class_2561.method_43470("(%d, %d, %d) [%s] -> (%d, %d, %d) [%s]".formatted(
                conduit.source.method_10263(),
                conduit.source.method_10264(),
                conduit.source.method_10260(),
                conduit.sourceDir,
                conduit.sink.method_10263(),
                conduit.sink.method_10264(),
                conduit.sink.method_10260(),
                conduit.sinkDir
        )).method_27692(class_124.field_1065);
    }

    public List<Iota> asActionResult() { return List.of(this); }
}
