package dev.kineticcat.hexportation.fabric.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTBuilder;
import dev.kineticcat.hexportation.fabric.api.Storage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

import javax.print.attribute.standard.MediaSize;
import java.util.Objects;

public class StorageViewIota extends Iota {

    public record GenericStorageView(Storage.Modes mode, Long amount, Long capacity, String InternalName, class_2561 DisplayName) {
        private static final String MODE_TAG = "Mode";
        private static final String AMOUNT_TAG = "Amount";
        private static final String CAPACITY_TAG = "Capacity";
        private static final String NAME_TAG = "Name";
        private static final String DISPLAY_TAG = "Display";
        public GenericStorageView() {this(null, null, null, null, null);}
        public GenericStorageView(StorageView<ItemVariant> view, Long kys) {
            this(
                    Storage.Modes.ITEM,
                    view.getAmount(),
                    view.getCapacity(),
                    view.getResource().getItem().toString(),
                    view.getResource().toStack().method_7954()
            );
        }
        public GenericStorageView(StorageView<FluidVariant> view, Double kys) {
            this(
                    Storage.Modes.FLUID,
                    view.getAmount(),
                    view.getCapacity(),
                    view.getResource().getFluid().toString(),
                    FluidVariantAttributes.getName(FluidVariant.of(view.getResource().getFluid(), view.getResource().getNbt()))
            );
        }
        public GenericStorageView(EnergyStorage view) {
            this(
                    Storage.Modes.ENERGY,
                    view.getAmount(),
                    view.getCapacity(),
                    "energy",
                    class_2561.method_43471("hexportation.energyname")
            );
        }

        public class_2487 serialise() {
            class_2487 ctag = new class_2487();
            ctag.method_10582(MODE_TAG, mode.name());
            ctag.method_10544(AMOUNT_TAG, amount);
            ctag.method_10544(CAPACITY_TAG, capacity);
            ctag.method_10582(NAME_TAG, InternalName);
            ctag.method_10566(DISPLAY_TAG, class_2519.method_23256(class_2561.class_2562.method_10867(DisplayName)));
            return ctag;
        }
        public GenericStorageView(class_2487 ctag) {
            this(
                    Storage.Modes.valueOf(ctag.method_10558(MODE_TAG)),
                    ctag.method_10537(AMOUNT_TAG),
                    ctag.method_10537(CAPACITY_TAG),
                    ctag.method_10558(NAME_TAG),
                    class_2561.class_2562.method_10877(ctag.method_10558(DISPLAY_TAG))
            );
        }
    }

    public StorageViewIota(GenericStorageView view) {
        super(HexportationIotaTypes.STORAGEVIEW, view);
    }
    public StorageViewIota(StorageView<ItemVariant> view, Long kys) {
        super(HexportationIotaTypes.STORAGEVIEW, new GenericStorageView(view, kys));
    }
    public StorageViewIota(StorageView<FluidVariant> view, Double kys) {
        super(HexportationIotaTypes.STORAGEVIEW, new GenericStorageView(view, kys));
    }
    public StorageViewIota(EnergyStorage view) {
        super(HexportationIotaTypes.STORAGEVIEW, new GenericStorageView(view));
    }
    public GenericStorageView getView() { return (GenericStorageView) payload;}

    @Override
    public boolean isTruthy() {
        return getView().mode != null;
    }

    @Override
    protected boolean toleratesOther(Iota that) {
        return typesMatch(this, that)
                && that instanceof StorageViewIota thon
                && Objects.equals(getView().InternalName, thon.getView().InternalName);
    }

    @Override
    public @NotNull class_2520 serialize() {
        return getView().serialise();
    }

    public static IotaType<StorageViewIota> TYPE = new IotaType<StorageViewIota>() {
        @Nullable
        @Override
        public StorageViewIota deserialize(class_2520 tag, class_3218 world) throws IllegalArgumentException {
            return new StorageViewIota(new GenericStorageView((class_2487) tag));
        }

        @Override
        public class_2561 display(class_2520 tag) {
            GenericStorageView view = new GenericStorageView((class_2487) tag);
            class_5250 out = ((class_5250) view.DisplayName);
            Long amt = view.amount;
            Long cap = view.capacity;
            // convert droplets to millibuckets
            if (view.mode == Storage.Modes.FLUID) {
                amt = amt/ FluidConstants.BUCKET * 1000;
                cap = cap/ FluidConstants.BUCKET * 1000;
            }
            out.method_27693(" ").method_27693(amt.toString()).method_27693("/").method_27693(cap.toString());
            switch (view.mode) {
                case ITEM -> {}
                case FLUID -> {
                    out.method_27693(" mB");
                }
                case ENERGY -> {
                    out.method_27693("E");
                }
            }
            return out.method_27692(class_124.field_1076);
        }

        @Override
        public int color() {
            return 0;
        }
    };
}
