package dev.kineticcat.hexportation.fabric.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import dev.kineticcat.hexportation.Hexportation;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class HexportationIotaTypes {
    private static final Map<class_2960, IotaType<?>> TYPES = new LinkedHashMap<>();

    public static void init() {
        for (Map.Entry<class_2960, IotaType<?>> entry : TYPES.entrySet()) {
            class_2378.method_10230(HexIotaTypes.REGISTRY, entry.getKey(), entry.getValue());
        }
    }

    public static final IotaType<ConduitIota> CONDUIT = type("conduit", ConduitIota.TYPE);
    public static final IotaType<StorageViewIota> STORAGEVIEW = type("storageview", StorageViewIota.TYPE);

    private static <U extends Iota, T extends IotaType<U>> T type(String name, T type) {
        IotaType<?> old = TYPES.put(new class_2960(Hexportation.MOD_ID, name), type);
        if (old != null) {
            throw new IllegalArgumentException("duplicate id :" + name + ", dingus");
        }
        return type;
    }
}
