/*
 * Decompiled with CFR 0.152.
 */
package dev.kineticcat.hexportation.fabric.casting;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.castables.OperationAction;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.lib.hex.HexActions;
import dev.kineticcat.hexportation.fabric.casting.actions.OpGetInvData;
import dev.kineticcat.hexportation.fabric.casting.actions.OpGetViewData;
import dev.kineticcat.hexportation.fabric.casting.actions.OpMakeConduit;
import dev.kineticcat.hexportation.fabric.casting.actions.OpSendThing;
import dev.kineticcat.hexportation.fabric.casting.actions.OpSendThingFiltered;
import dev.kineticcat.hexportation.fabric.casting.actions.OpSlurp;
import dev.kineticcat.hexportation.fabric.casting.actions.OpSpit;
import dev.kineticcat.hexportation.fabric.casting.actions.OpTransplace;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ram.talia.moreiotas.api.casting.iota.StringIota;

public class HexportationPatternRegistry {
    public static final Logger LOGGER = LogManager.getLogger((String)"hexportation");
    private static final Map<class_2960, ActionRegistryEntry> PATTERNS = new LinkedHashMap<class_2960, ActionRegistryEntry>();
    public static final HexPattern MAKE_CONDUIT = HexportationPatternRegistry.make("eadewewedaedwqeadewewedaedww", HexDir.NORTH_EAST, "make_conduit", (Action)OpMakeConduit.INSTANCE);
    public static final HexPattern SEND_ITEM = HexportationPatternRegistry.make("qadeeedewe", HexDir.SOUTH_EAST, "send_item", (Action)OpSendThing.INSTANCE);
    public static final HexPattern GET_SOURCE_INV = HexportationPatternRegistry.make("eeeeedwwadeeede", HexDir.NORTH_EAST, "get_source_inv", (Action)new OpGetInvData(false));
    public static final HexPattern GET_SINK_INV = HexportationPatternRegistry.make("deeedeqeeeeedw", HexDir.NORTH_WEST, "get_sink_inv", (Action)new OpGetInvData(true));
    public static final HexPattern SEND_ITEM_FILT = HexportationPatternRegistry.make("deeedewadeeede", HexDir.NORTH_WEST, "send_item_filt", (Action)OpSendThingFiltered.INSTANCE);
    public static final HexPattern GET_VIEW_AMOUNT = HexportationPatternRegistry.make("adeeedewq", HexDir.EAST, "get_view_amount", (Action)new OpGetViewData(view -> new DoubleIota(view.amount().doubleValue())));
    public static final HexPattern GET_VIEW_CAPACITY = HexportationPatternRegistry.make("adeeedeww", HexDir.EAST, "get_view_capacity", (Action)new OpGetViewData(view -> new DoubleIota(view.capacity().doubleValue())));
    public static final HexPattern GET_VIEW_NAME = HexportationPatternRegistry.make("adeeedewe", HexDir.EAST, "get_view_name", (Action)new OpGetViewData(view -> StringIota.makeUnchecked((String)view.InternalName())));
    public static final HexPattern SLURP = HexportationPatternRegistry.make("aqaawdaqqqaqw", HexDir.SOUTH_EAST, "slurp", (Action)OpSlurp.INSTANCE);
    public static final HexPattern SPIT = HexportationPatternRegistry.make("daqqqaqeaqaa", HexDir.EAST, "spit", (Action)OpSpit.INSTANCE);
    public static final HexPattern TRANSPLACE = HexportationPatternRegistry.make("aqaawdaqqqaqeaqaa", HexDir.SOUTH_EAST, "transplace", (Action)OpTransplace.INSTANCE);

    public static void init() {
        for (Map.Entry<class_2960, ActionRegistryEntry> entry : PATTERNS.entrySet()) {
            class_2378.method_10230((class_2378)HexActions.REGISTRY, (class_2960)entry.getKey(), (Object)entry.getValue());
        }
    }

    private static HexPattern make(String signature, HexDir dir, String name, Action act) {
        PATTERNS.put(new class_2960("hexportation", name), new ActionRegistryEntry(HexPattern.fromAngles((String)signature, (HexDir)dir), act));
        return HexPattern.fromAngles((String)signature, (HexDir)dir);
    }

    private static HexPattern make(String signature, HexDir dir, String name) {
        HexPattern pattern = HexPattern.fromAngles((String)signature, (HexDir)dir);
        PATTERNS.put(new class_2960("hexportation", name), new ActionRegistryEntry(pattern, (Action)new OperationAction(pattern)));
        return pattern;
    }
}

