/*
 * Decompiled with CFR 0.152.
 */
package dev.kineticcat.hexportation.fabric.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import dev.kineticcat.hexportation.fabric.api.casting.iota.HexportationIotaTypes;
import java.util.List;
import java.util.Objects;
import kotlin.Pair;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_4614;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;

public class ConduitIota
extends Iota {
    public static IotaType<ConduitIota> TYPE = new IotaType<ConduitIota>(){

        public ConduitIota deserialize(class_2520 tag, class_3218 world) throws IllegalArgumentException {
            return ConduitIota.deserialize(tag);
        }

        public class_2561 display(class_2520 tag) {
            return ConduitIota.display(ConduitIota.deserialize(tag).getConduit());
        }

        public int color() {
            return 0xFFAA00;
        }
    };

    public ConduitIota(class_2338 source, class_2350 sourceDir, class_2338 sink, class_2350 sinkDir) {
        super(HexportationIotaTypes.CONDUIT, (Object)new Conduit(source, sourceDir, sink, sinkDir));
    }

    public ConduitIota(Conduit conduit) {
        super(HexportationIotaTypes.CONDUIT, (Object)conduit);
    }

    public Conduit getConduit() {
        return (Conduit)this.payload;
    }

    public boolean isTruthy() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean toleratesOther(Iota that) {
        if (!ConduitIota.typesMatch((Iota)this, (Iota)that)) return false;
        if (!(that instanceof ConduitIota)) return false;
        ConduitIota iota = (ConduitIota)that;
        if (!ConduitIota.tolerates(this.getConduit(), iota.getConduit())) return false;
        return true;
    }

    public static boolean tolerates(Conduit A, Conduit B) {
        return A.equals(B);
    }

    @NotNull
    public class_2520 serialize() {
        return this.getConduit().serialise();
    }

    public static ConduitIota deserialize(class_2520 tag) {
        class_2487 ctag = (class_2487)HexUtils.downcast((class_2520)tag, (class_4614)class_2487.field_21029);
        return new Conduit((class_2487)tag).asIota();
    }

    public static class_2561 display(Conduit conduit) {
        return class_2561.method_43470((String)"(%d, %d, %d) [%s] -> (%d, %d, %d) [%s]".formatted(conduit.source.method_10263(), conduit.source.method_10264(), conduit.source.method_10260(), conduit.sourceDir, conduit.sink.method_10263(), conduit.sink.method_10264(), conduit.sink.method_10260(), conduit.sinkDir)).method_27692(class_124.field_1065);
    }

    public List<Iota> asActionResult() {
        return List.of(this);
    }

    public record Conduit(class_2338 source, class_2350 sourceDir, class_2338 sink, class_2350 sinkDir) {
        private static final String SOURCE_TAG = "Source";
        private static final String SOURCE_DIR_TAG = "SourceDir";
        private static final String SINK_TAG = "Sink";
        private static final String SINK_DIR_TAG = "SinkDir";

        public Conduit(class_2487 ctag) {
            this(Conduit.deserialisePos((class_2487)ctag.method_10580(SOURCE_TAG)), class_2350.method_10168((String)ctag.method_10558(SOURCE_DIR_TAG)), Conduit.deserialisePos((class_2487)ctag.method_10580(SINK_TAG)), class_2350.method_10168((String)ctag.method_10558(SINK_DIR_TAG)));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Conduit conduit = (Conduit)o;
            return Objects.equals(this.source, conduit.source) && this.sourceDir == conduit.sourceDir && Objects.equals(this.sink, conduit.sink) && this.sinkDir == conduit.sinkDir;
        }

        private static class_2487 serialisePos(class_2338 pos) {
            class_2487 ctag = new class_2487();
            ctag.method_10569("X", pos.method_10263());
            ctag.method_10569("Y", pos.method_10264());
            ctag.method_10569("Z", pos.method_10260());
            return ctag;
        }

        public class_2487 serialise() {
            class_2487 ctag = new class_2487();
            ctag.method_10566(SOURCE_TAG, (class_2520)Conduit.serialisePos(this.source));
            ctag.method_10582(SOURCE_DIR_TAG, this.sourceDir.method_15434());
            ctag.method_10566(SINK_TAG, (class_2520)Conduit.serialisePos(this.sink));
            ctag.method_10582(SINK_DIR_TAG, this.sinkDir.method_15434());
            return ctag;
        }

        private static class_2338 deserialisePos(class_2487 ctag) {
            return new class_2338(ctag.method_10550("X"), ctag.method_10550("Y"), ctag.method_10550("Z"));
        }

        public ConduitIota asIota() {
            return new ConduitIota(this);
        }

        public Pair<Storage<ItemVariant>, Storage<ItemVariant>> getItemStoragesOrNull(class_3218 sLevel) {
            Storage sourceStorage = (Storage)ItemStorage.SIDED.find((class_1937)sLevel, this.source, (Object)this.sourceDir);
            Storage sinkStorage = (Storage)ItemStorage.SIDED.find((class_1937)sLevel, this.sink, (Object)this.sinkDir);
            return new Pair((Object)sourceStorage, (Object)sinkStorage);
        }

        public Pair<Storage<FluidVariant>, Storage<FluidVariant>> getFluidStoragesOrNull(class_3218 sLevel) {
            Storage sourceStorage = (Storage)FluidStorage.SIDED.find((class_1937)sLevel, this.source, (Object)this.sourceDir);
            Storage sinkStorage = (Storage)FluidStorage.SIDED.find((class_1937)sLevel, this.sink, (Object)this.sinkDir);
            return new Pair((Object)sourceStorage, (Object)sinkStorage);
        }

        public Pair<EnergyStorage, EnergyStorage> getEnergyStoragesOrNull(class_3218 sLevel) {
            EnergyStorage sourceStorage = (EnergyStorage)EnergyStorage.SIDED.find((class_1937)sLevel, this.source, (Object)this.sourceDir);
            EnergyStorage sinkStorage = (EnergyStorage)EnergyStorage.SIDED.find((class_1937)sLevel, this.sink, (Object)this.sinkDir);
            if (sourceStorage != null && sinkStorage != null) {
                return new Pair((Object)sourceStorage, (Object)sinkStorage);
            }
            return null;
        }
    }
}

